/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.osgi.framework.Bundle;

public class Utils {
    public static boolean RUNNING_TESTS = false;
    public static boolean TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE = false;
    public static final Comparator<IResource> resourceComparator = new Comparator<IResource>(){

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        @Override
        public int compare(IResource o1, IResource o2) {
            return o1.getFullPath().toString().compareTo(o2.getFullPath().toString());
        }
    };

    public static void handleError(Shell shell, Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        Throwable t = exception;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.TeamAction_internal, t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog && shell != null) {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)toShow);
            }
            if (log || shell == null) {
                TeamUIPlugin.log(toShow.getSeverity(), message, t);
            }
        }
    }

    public static void runWithProgress(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell = false;
        try {
            if (parent == null || parent.isDisposed()) {
                Display display = Display.getCurrent();
                if (display == null) {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                parent = display.getActiveShell();
                if (parent == null) {
                    parent = new Shell(display);
                    createdShell = true;
                }
            }
            Exception[] holder = new Exception[1];
            BusyIndicator.showWhile((Display)parent.getDisplay(), () -> {
                try {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e1) {
                    exceptionArray[0] = e1;
                }
                catch (InterruptedException e2) {
                    exceptionArray[0] = e2;
                }
            });
            if (holder[0] != null) {
                if (holder[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)holder[0];
                }
                throw (InterruptedException)holder[0];
            }
        }
        finally {
            if (createdShell) {
                parent.dispose();
            }
        }
    }

    public static Shell getShell(IWorkbenchSite site) {
        return Utils.getShell(site, false);
    }

    public static Shell getShell(IWorkbenchSite site, boolean syncIfNecessary) {
        IWorkbenchWindow window;
        Shell shell;
        if (site != null && !(shell = site.getShell()).isDisposed()) {
            return shell;
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            if (display.isDisposed()) {
                return null;
            }
            if (syncIfNecessary) {
                Shell[] result = new Shell[1];
                Runnable r = () -> {
                    Shell shell = new Shell(Display.getDefault());
                };
                display.syncExec(r);
                return result[0];
            }
        }
        if (display.isDisposed()) {
            return null;
        }
        return new Shell(display);
    }

    public static void handle(Throwable exception) {
        TeamUIPlugin.getStandardDisplay().asyncExec(() -> {
            Object error = null;
            Throwable t = exception;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.simpleInternal, t));
            Shell shell = new Shell(Display.getDefault());
            if (error.getSeverity() == 1) {
                MessageDialog.openInformation((Shell)shell, (String)TeamUIMessages.information, (String)error.getMessage());
            } else {
                ErrorDialog.openError((Shell)shell, (String)TeamUIMessages.exception, null, (IStatus)error);
            }
            shell.dispose();
            if (!(t instanceof TeamException)) {
                TeamUIPlugin.log(error.getSeverity(), error.getMessage(), t);
            }
        });
    }

    public static Shell findShell() {
        Display display = TeamUIPlugin.getStandardDisplay();
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            return activeShell;
        }
        return new Shell(display);
    }

    public static void initAction(IAction a, String prefix) {
        Utils.initAction(a, prefix, Policy.getActionBundle());
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle) {
        Utils.initAction(a, prefix, bundle, null);
    }

    public static void updateLabels(SyncInfo sync, CompareConfiguration config, IProgressMonitor monitor) {
        String baseContentId;
        IResourceVariant remote = sync.getRemote();
        IResourceVariant base = sync.getBase();
        String baseAuthor = null;
        String remoteAuthor = null;
        String localAuthor = null;
        String localContentId = sync.getLocalContentIdentifier();
        String remoteContentId = remote != null ? remote.getContentIdentifier() : null;
        String string = baseContentId = base != null ? base.getContentIdentifier() : null;
        if (Utils.isShowAuthor()) {
            baseAuthor = Utils.getAuthor(base, monitor);
            remoteAuthor = baseContentId != null && baseContentId.equals(remoteContentId) ? baseAuthor : Utils.getAuthor(remote, monitor);
            if (localContentId != null) {
                localAuthor = localContentId.equals(baseContentId) ? baseAuthor : (localContentId.equals(remoteAuthor) ? remoteAuthor : sync.getLocalAuthor(monitor));
            }
        }
        if (localContentId != null) {
            if (localAuthor != null) {
                config.setLeftLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelAuthorExists, (Object[])new String[]{localContentId, localAuthor}));
            } else {
                config.setLeftLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_localLabelExists, (Object[])new String[]{localContentId}));
            }
        } else {
            config.setLeftLabel(TeamUIMessages.SyncInfoCompareInput_localLabel);
        }
        if (remote != null) {
            if (remoteAuthor != null) {
                config.setRightLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelAuthorExists, (Object[])new String[]{remoteContentId, remoteAuthor}));
            } else {
                config.setRightLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_remoteLabelExists, (Object[])new String[]{remoteContentId}));
            }
        } else {
            config.setRightLabel(TeamUIMessages.SyncInfoCompareInput_remoteLabel);
        }
        if (base != null) {
            if (baseAuthor != null) {
                config.setAncestorLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelAuthorExists, (Object[])new String[]{baseContentId, baseAuthor}));
            } else {
                config.setAncestorLabel(NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_baseLabelExists, (Object[])new String[]{baseContentId}));
            }
        } else {
            config.setAncestorLabel(TeamUIMessages.SyncInfoCompareInput_baseLabel);
        }
    }

    @Deprecated
    public static void updateLabels(SyncInfo sync, CompareConfiguration config) {
        Utils.updateLabels(sync, config, null);
    }

    public static boolean isShowAuthor() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        return store.getBoolean("org.eclipse.team.ui.show_author_in_compare_editor");
    }

    private static String getAuthor(IResourceVariant variant, IProgressMonitor monitor) {
        String author = null;
        if (variant instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)variant;
            IFileRevision revision = (IFileRevision)adaptable.getAdapter(IFileRevision.class);
            if (revision == null) {
                return null;
            }
            try {
                IFileRevision complete = revision.withAllProperties(monitor);
                if (complete != null) {
                    author = complete.getAuthor();
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return author;
    }

    public static String getLocalContentId(IDiff diff) {
        IFileRevision revision;
        IResourceDiff rd;
        IResource resource;
        IFileHistoryProvider provider;
        IThreeWayDiff twd;
        if (diff instanceof IThreeWayDiff && (diff = (twd = (IThreeWayDiff)diff).getLocalChange()) == null) {
            diff = twd.getRemoteChange();
        }
        if (diff instanceof IResourceDiff && (provider = Utils.getHistoryProvider(resource = (rd = (IResourceDiff)diff).getResource())) != null && (revision = provider.getWorkspaceFileRevision(resource)) != null) {
            return revision.getContentIdentifier();
        }
        return null;
    }

    public static IFileHistoryProvider getHistoryProvider(IResource resource) {
        RepositoryProvider rp = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (rp != null) {
            return rp.getFileHistoryProvider();
        }
        return null;
    }

    public static IFileRevision getBase(IDiff diff) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff remoteChange = twd.getRemoteChange();
            if (remoteChange instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)remoteChange;
                return rd.getBeforeState();
            }
            ITwoWayDiff localChange = twd.getLocalChange();
            if (localChange instanceof IResourceDiff) {
                IResourceDiff ld = (IResourceDiff)localChange;
                return ld.getBeforeState();
            }
        }
        return null;
    }

    public static IFileRevision getRemote(IDiff diff) {
        if (diff instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)diff;
            return rd.getAfterState();
        }
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            ITwoWayDiff remoteChange = twd.getRemoteChange();
            if (remoteChange instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)remoteChange;
                return rd.getAfterState();
            }
            ITwoWayDiff localChange = twd.getLocalChange();
            if (localChange instanceof IResourceDiff) {
                IResourceDiff ld = (IResourceDiff)localChange;
                return ld.getBeforeState();
            }
        }
        return null;
    }

    public static void initAction(IAction a, String prefix, ResourceBundle bundle, String[] bindings) {
        String relPath;
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        String s = null;
        s = bindings != null ? NLS.bind((String)Utils.getString(labelKey, bundle), (Object[])bindings) : Utils.getString(labelKey, bundle);
        if (s != null) {
            a.setText(s);
        }
        if ((s = Utils.getString(tooltipKey, bundle)) != null) {
            a.setToolTipText(s);
        }
        if ((s = Utils.getString(descriptionKey, bundle)) != null) {
            a.setDescription(s);
        }
        if ((relPath = Utils.getString(imageKey, bundle)) != null && !relPath.equals(imageKey) && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.contains("/")) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = TeamImages.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = TeamUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
            }
        }
    }

    public static String getString(String key, ResourceBundle b) {
        try {
            return b.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case 1: {
                return TeamUIMessages.Utils_22;
            }
            case 2: {
                return TeamUIMessages.Utils_23;
            }
            case 4: {
                return TeamUIMessages.Utils_24;
            }
            case 8: {
                return TeamUIMessages.Utils_25;
            }
        }
        return TeamUIMessages.Utils_26;
    }

    private static IResource[] getResources(Object[] elements, List<Object> nonResources, boolean isContributed, boolean includeMappingResources) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            boolean isResource = false;
            if (element instanceof IResource) {
                resources.add((IResource)element);
                isResource = true;
            } else if (element instanceof ISynchronizeModelElement) {
                IResource resource = ((ISynchronizeModelElement)element).getResource();
                if (resource != null) {
                    resources.add(resource);
                    isResource = true;
                }
            } else if (element instanceof ResourceMapping) {
                if (includeMappingResources) {
                    isResource = true;
                    Utils.getResources((ResourceMapping)element, resources);
                }
            } else if (element != null) {
                Object adapted = isContributed ? Utils.getResource(element) : Adapters.adapt((Object)element, IResource.class);
                if (adapted instanceof IResource) {
                    Object resource = adapted;
                    isResource = true;
                    if (resource.getType() != 8) {
                        resources.add((IResource)resource);
                    }
                } else {
                    adapted = isContributed ? Utils.getResourceMapping(element) : Adapters.adapt((Object)element, ResourceMapping.class);
                    if (adapted instanceof ResourceMapping && includeMappingResources) {
                        isResource = true;
                        Utils.getResources((ResourceMapping)adapted, resources);
                    }
                }
            }
            if (!isResource && nonResources != null) {
                nonResources.add(element);
            }
            ++n2;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static void getResources(ResourceMapping element, List<IResource> resources) {
        try {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = element.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] resourceArray = traversal.getResources();
                Collections.addAll(resources, resourceArray);
                ++n2;
            }
        }
        catch (CoreException e) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 0, "Error traversing resource mapping", (Throwable)e));
        }
    }

    public static Object[] getNonResources(Object[] elements) {
        ArrayList<Object> nonResources = new ArrayList<Object>();
        Utils.getResources(elements, nonResources, false, false);
        return nonResources.toArray();
    }

    public static IResource[] getResources(Object[] element) {
        return Utils.getResources(element, null, false, false);
    }

    public static IResource[] getContributedResources(Object[] elements) {
        return Utils.getResources(elements, null, true, true);
    }

    public static boolean hasMatchingDescendant(IStructuredSelection selection, FastSyncInfoFilter filter) {
        for (Object o : selection) {
            if (!(o instanceof ISynchronizeModelElement) || !Utils.hasMatchingDescendant((ISynchronizeModelElement)o, filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMatchingDescendant(ISynchronizeModelElement element, FastSyncInfoFilter filter) {
        IDiffElement[] children;
        SyncInfo info;
        if (element.getKind() != 0 && element instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)element).getSyncInfo()) != null && filter.select(info)) {
            return true;
        }
        IDiffElement[] iDiffElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            if (child instanceof ISynchronizeModelElement && Utils.hasMatchingDescendant((ISynchronizeModelElement)child, filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IDiffElement[] getDiffNodes(Object[] selected) {
        HashSet<IDiffElement> result = new HashSet<IDiffElement>();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IDiffElement) {
                Utils.collectAllNodes((IDiffElement)object, result);
            }
            ++n2;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private static void collectAllNodes(IDiffElement element, Set<IDiffElement> nodes) {
        if (element.getKind() != 0) {
            nodes.add(element);
        }
        if (element instanceof IDiffContainer) {
            IDiffElement[] children;
            IDiffElement[] iDiffElementArray = children = ((IDiffContainer)element).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement c = iDiffElementArray[n2];
                Utils.collectAllNodes(c, nodes);
                ++n2;
            }
        }
    }

    public static void schedule(Job job, IWorkbenchSite site) {
        IWorkbenchSiteProgressService siteProgress;
        if (site != null && (siteProgress = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            siteProgress.schedule(job, 0L, true);
            return;
        }
        job.schedule();
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                }
                try {
                    bos.close();
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    public static boolean equalObject(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String getKey(String id, String secondaryId) {
        return secondaryId == null ? id : String.valueOf(id) + '/' + secondaryId;
    }

    public static String convertSelection(IResource[] resources) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(resource.getFullPath());
            ++i;
        }
        return buffer.toString();
    }

    public static String shortenText(int maxWidth, String textValue) {
        int length = textValue.length();
        if (length < maxWidth) {
            return textValue;
        }
        String ellipsis = "...";
        int subStrLen = (maxWidth - ellipsis.length()) / 2;
        int addtl = (maxWidth - ellipsis.length()) % 2;
        StringBuilder sb = new StringBuilder(maxWidth);
        sb.append(textValue.substring(0, subStrLen));
        sb.append(ellipsis);
        sb.append(textValue.substring(length - subStrLen - addtl));
        return sb.toString();
    }

    public static String getTypeName(ISynchronizeParticipant participant) {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        return manager.getParticipantDescriptor(participant.getId()).getName();
    }

    public static boolean canUpdateViewer(StructuredViewer viewer) {
        if (viewer == null || viewer.getControl().isDisposed()) {
            return false;
        }
        Display display = viewer.getControl().getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static void asyncExec(Runnable r, StructuredViewer v) {
        if (v == null) {
            return;
        }
        Control ctrl = v.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(() -> {
                if (!ctrl.isDisposed()) {
                    BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                }
            });
        }
    }

    public static void syncExec(Runnable r, StructuredViewer v) {
        if (v == null) {
            return;
        }
        Control ctrl = v.getControl();
        Utils.syncExec(r, ctrl);
    }

    public static void syncExec(Runnable r, Control ctrl) {
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(() -> {
                if (!ctrl.isDisposed()) {
                    BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                }
            });
        }
    }

    public static void asyncExec(Runnable r, Control ctrl) {
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(() -> {
                if (!ctrl.isDisposed()) {
                    BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)r);
                }
            });
        }
    }

    public static SyncInfo getSyncInfo(ISynchronizeModelElement node) {
        if (node instanceof IAdaptable) {
            return (SyncInfo)((IAdaptable)node).getAdapter(SyncInfo.class);
        }
        return null;
    }

    public static ISynchronizationCompareAdapter getCompareAdapter(Object element) {
        Object o;
        ModelProvider provider = Utils.getModelProvider(element);
        if (provider != null && (o = provider.getAdapter(ISynchronizationCompareAdapter.class)) instanceof ISynchronizationCompareAdapter) {
            return (ISynchronizationCompareAdapter)o;
        }
        return null;
    }

    public static ModelProvider getModelProvider(Object o) {
        if (o instanceof ModelProvider) {
            return (ModelProvider)o;
        }
        ResourceMapping mapping = Utils.getResourceMapping(o);
        if (mapping != null) {
            return mapping.getModelProvider();
        }
        return null;
    }

    public static IResource getResource(Object o) {
        IContributorResourceAdapter adapter;
        IAdaptable adaptable;
        IResource resource = null;
        if (o instanceof IResource) {
            resource = (IResource)o;
        } else if (o instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)o).getAdapter(IResource.class)) == null && (adapter = (IContributorResourceAdapter)adaptable.getAdapter(IContributorResourceAdapter.class)) != null) {
            resource = adapter.getAdaptedResource(adaptable);
        }
        return resource;
    }

    public static ResourceMapping getResourceMapping(Object o) {
        if (o instanceof ResourceMapping) {
            return (ResourceMapping)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            Object adapted = adaptable.getAdapter(ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
            adapted = adaptable.getAdapter(IContributorResourceAdapter.class);
            if (adapted instanceof IContributorResourceAdapter2) {
                IContributorResourceAdapter2 cra = (IContributorResourceAdapter2)adapted;
                return cra.getAdaptedResourceMapping(adaptable);
            }
        } else {
            Object adapted = Platform.getAdapterManager().getAdapter(o, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }

    public static ResourceMapping[] getResourceMappings(Object[] objects) {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                result.add(mapping);
            }
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public static String getLabel(ResourceMapping mapping) {
        ModelProvider provider = mapping.getModelProvider();
        ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
        if (adapter == null) {
            return "";
        }
        String pathString = adapter.getPathString(mapping);
        if (pathString == null || pathString.length() == 0) {
            return adapter.getName(mapping);
        }
        return pathString;
    }

    public static String getLabel(ModelProvider provider) {
        String base;
        ResourceMapping mapping = Utils.getResourceMapping(provider);
        if (mapping != null && (base = Utils.getLabel(mapping)) != null && base.length() > 0) {
            return base;
        }
        return provider.getDescriptor().getLabel();
    }

    public static String getScopeDescription(ISynchronizationScope scope) {
        ResourceMapping[] mappings = scope.getInputMappings();
        if (mappings.length == 1) {
            String label = Utils.getLabel(mappings[0]);
            if (label == null) {
                return TeamUIMessages.Utils_19;
            }
            return label;
        }
        String desc = Utils.convertSelection(mappings);
        if (desc.length() > 0) {
            return Utils.shortenText(30, desc);
        }
        return NLS.bind((String)TeamUIMessages.Utils_18, (Object)mappings.length);
    }

    public static String convertSelection(ResourceMapping[] mappings) {
        StringBuilder buffer = new StringBuilder();
        boolean hadOne = false;
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping resourceMapping = resourceMappingArray[n2];
            String label = Utils.getLabel(resourceMapping);
            if (label != null) {
                if (hadOne) {
                    buffer.append(", ");
                }
                hadOne = true;
                buffer.append(label);
            }
            ++n2;
        }
        return buffer.toString();
    }

    public static ResourceTraversal[] getTraversals(Object[] elements) throws CoreException {
        CompoundResourceTraversal traversal = new CompoundResourceTraversal();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                traversal.addTraversals(mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null));
            }
            ++n2;
        }
        return traversal.asTraversals();
    }

    public static boolean isTextEditor(IEditorDescriptor descriptor) throws CoreException {
        if (!(descriptor instanceof EditorDescriptor)) {
            return false;
        }
        EditorDescriptor desc = (EditorDescriptor)descriptor;
        String className = desc.getClassName();
        String contributor = desc.getPluginId();
        if (className == null || contributor == null) {
            return false;
        }
        try {
            Bundle bundle = Platform.getBundle((String)contributor);
            if (bundle != null) {
                Class clazz = bundle.loadClass(className);
                return AbstractDecoratedTextEditor.class.isAssignableFrom(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        IEditorPart editor = desc.createEditor();
        editor.dispose();
        return editor instanceof AbstractDecoratedTextEditor;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        IStorage file = revision.getStorage(monitor);
        if (file instanceof IFile) {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)file), (boolean)OpenStrategy.activateOnOpen());
        }
        FileRevisionEditorInput fileRevEditorInput = FileRevisionEditorInput.createEditorInputFor(revision, monitor);
        IEditorPart part = Utils.openEditor(page, fileRevEditorInput);
        return part;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput) throws PartInitException {
        String id = Utils.getEditorId(editorInput);
        return Utils.openEditor(page, editorInput, id);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput, String editorId) throws PartInitException {
        try {
            IEditorPart part = page.openEditor((IEditorInput)editorInput, editorId, OpenStrategy.activateOnOpen());
            if (part instanceof ErrorEditorPart) {
                page.closeEditor(part, false);
                part = null;
            }
            if (part == null) {
                throw new PartInitException(NLS.bind((String)TeamUIMessages.Utils_17, (Object)editorId));
            }
            return part;
        }
        catch (PartInitException e) {
            if (editorId.equals("org.eclipse.ui.DefaultTextEditor")) {
                throw e;
            }
            return page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
        }
    }

    public static IEditorDescriptor[] getEditors(IFileRevision revision) {
        String name = revision.getName();
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor[] editorDescs = registry.getEditors(name);
        return IDE.overrideEditorAssociations((String)name, null, (IEditorDescriptor[])editorDescs);
    }

    public static IEditorDescriptor getDefaultEditor(IFileRevision revision) {
        String name = revision.getName();
        try {
            return IDE.getEditorDescriptor((String)name);
        }
        catch (PartInitException partInitException) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            return registry.getDefaultEditor(name);
        }
    }

    private static String getEditorId(FileRevisionEditorInput editorInput) {
        String id = Utils.getEditorId(editorInput, Utils.getContentType(editorInput));
        return id;
    }

    private static IContentType getContentType(FileRevisionEditorInput editorInput) {
        IContentType type = null;
        try {
            InputStream contents = editorInput.getStorage().getContents();
            try {
                type = Utils.getContentType(editorInput.getFileRevision().getName(), contents);
            }
            catch (Throwable throwable) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
            }
            catch (IOException iOException) {}
        }
        catch (CoreException e) {
            TeamUIPlugin.log(4, NLS.bind((String)"An error occurred reading the contents of file {0}", (Object[])new String[]{editorInput.getName()}), e);
        }
        return type;
    }

    private static IContentType getContentType(String fileName, InputStream contents) {
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException e) {
                TeamUIPlugin.log(4, NLS.bind((String)"An error occurred reading the contents of file {0}", (Object)fileName), e);
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        return type;
    }

    private static String getEditorId(FileRevisionEditorInput editorInput, IContentType type) {
        String fileName = editorInput.getFileRevision().getName();
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(fileName, type);
        IDE.overrideDefaultEditorAssociation((IEditorInput)editorInput, (IContentType)type, (IEditorDescriptor)descriptor);
        String id = descriptor == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    public static IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page, Class[] editorInputClasses) {
        IEditorPart part;
        IEditorReference editorRef;
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && part instanceof IReusableEditor) {
                Class[] classArray = editorInputClasses;
                int n3 = editorInputClasses.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class editorInputClasse = classArray[n4];
                    if (editorInputClasse.isInstance(part.getEditorInput()) && part.getEditorInput().equals(input)) {
                        return part;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.reuse_open_compare_editors")) {
            iEditorReferenceArray = editorRefs;
            n = editorRefs.length;
            n2 = 0;
            while (n2 < n) {
                editorRef = iEditorReferenceArray[n2];
                part = editorRef.getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++n2;
            }
        }
        return null;
    }

    public static abstract class Sorter {
        public abstract boolean compare(Object var1, Object var2);

        private Object[] quickSort(Object[] sortedCollection, int left, int right) {
            int originalLeft = left;
            int originalRight = right;
            Object mid = sortedCollection[left + right >>> 1];
            while (true) {
                if (this.compare(sortedCollection[left], mid)) {
                    ++left;
                    continue;
                }
                while (this.compare(mid, sortedCollection[right])) {
                    --right;
                }
                if (left <= right) {
                    Object tmp = sortedCollection[left];
                    sortedCollection[left] = sortedCollection[right];
                    sortedCollection[right] = tmp;
                    ++left;
                    --right;
                }
                if (left > right) break;
            }
            if (originalLeft < right) {
                sortedCollection = this.quickSort(sortedCollection, originalLeft, right);
            }
            if (left < originalRight) {
                sortedCollection = this.quickSort(sortedCollection, left, originalRight);
            }
            return sortedCollection;
        }

        public Object[] sort(Object[] unSortedCollection) {
            int size = unSortedCollection.length;
            Object[] sortedCollection = new Object[size];
            System.arraycopy(unSortedCollection, 0, sortedCollection, 0, size);
            if (size > 1) {
                this.quickSort(sortedCollection, 0, size - 1);
            }
            return sortedCollection;
        }
    }
}

