/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.internal.ContextSet;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessDialog;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.keys.IBindingService;

public class SearchField {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    private ToolItem quickAccessButton;
    private Display display;
    private ParameterizedCommand quickAccessCommand;
    private TriggerSequence triggerSequence = null;
    private Listener previousFocusListener = e -> {
        if (e.widget instanceof Control && e.widget != this.quickAccessButton) {
            this.previousFocusControl = (Control)e.widget;
        }
    };
    private Control previousFocusControl;
    @Inject
    private BindingTableManager manager;
    @Inject
    private ECommandService eCommandService;
    @Inject
    private IContextService contextService;
    @Inject
    private IBindingService bindingService;
    @Inject
    private ICommandImageService commandImageService;

    @PostConstruct
    void createControls(Composite parent) {
        this.quickAccessCommand = this.eCommandService.createCommand(QUICK_ACCESS_COMMAND_ID, null);
        this.display = parent.getDisplay();
        this.display.addFilter(15, this.previousFocusListener);
        Composite comp = new Composite(parent, 0);
        comp.setSize(-1, 32);
        GridLayoutFactory.swtDefaults().margins(3, 3).applyTo(comp);
        this.updateQuickAccessTriggerSequence();
        this.quickAccessButton = this.createQuickAccessToolbar(comp);
        this.updateQuickAccessText();
        this.quickAccessButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.activate(this.previousFocusControl)));
    }

    @Inject
    @Optional
    protected void keybindingPreferencesChanged(@Preference(nodePath="org.eclipse.ui.workbench", value="org.eclipse.ui.commands") String preferenceValue) {
        if (preferenceValue != null) {
            this.updateQuickAccessText();
        }
    }

    protected void updateQuickAccessTriggerSequence() {
        this.triggerSequence = this.bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        if (this.triggerSequence == null) {
            ContextSet contextSet = this.manager.createContextSet(Arrays.asList(this.contextService.getDefinedContexts()));
            Binding binding = this.manager.getBestSequenceFor(contextSet, this.quickAccessCommand);
            this.triggerSequence = binding == null ? null : binding.getTriggerSequence();
        }
    }

    private ToolItem createQuickAccessToolbar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginRight = 8;
        layout.marginLeft = 8;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        comp.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar(comp, 8519744);
        ToolItem quickAccessToolItem = new ToolItem(toolbar, 8);
        try {
            quickAccessToolItem.setText(this.quickAccessCommand.getName());
        }
        catch (NotDefinedException e2) {
            WorkbenchPlugin.log(e2);
        }
        ImageDescriptor imageDescriptor = this.commandImageService.getImageDescriptor(this.quickAccessCommand.getId());
        if (imageDescriptor != null) {
            Image image = imageDescriptor.createImage();
            quickAccessToolItem.setImage(image);
            quickAccessToolItem.addDisposeListener(e -> image.dispose());
        }
        toolbar.addMenuDetectListener(e -> {
            if (toolbar.getMenu() == null) {
                toolbar.setMenu(parent.getMenu());
                e.doit = true;
            }
        });
        return quickAccessToolItem;
    }

    private void updateQuickAccessText() {
        if (this.quickAccessButton == null || this.quickAccessButton.isDisposed()) {
            return;
        }
        this.updateQuickAccessTriggerSequence();
        if (this.triggerSequence != null) {
            this.quickAccessButton.setToolTipText(NLS.bind((String)QuickAccessMessages.QuickAccess_TooltipDescription, (Object)this.triggerSequence.format()));
        } else {
            this.quickAccessButton.setToolTipText(QuickAccessMessages.QuickAccess_TooltipDescription_Empty);
        }
        this.quickAccessButton.getParent().requestLayout();
    }

    public void activate(Control previousFocusControl) {
        QuickAccessDialog quickAccessDialog = new QuickAccessDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null);
        quickAccessDialog.getShell().addDisposeListener(e -> {
            if (previousFocusControl != null && !previousFocusControl.isDisposed()) {
                previousFocusControl.setFocus();
            } else {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getShell().setFocus();
                }
            }
        });
        quickAccessDialog.open();
    }

    @PreDestroy
    void dispose() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(15, this.previousFocusListener);
        }
    }
}

