/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareDialog;
import org.eclipse.compare.internal.CompareFilterDescriptor;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareResourceFilter;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.compare.internal.Policy;
import org.eclipse.compare.internal.StreamMergerDescriptor;
import org.eclipse.compare.internal.StructureCreatorDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.internal.core.ComparePlugin;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class CompareUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 1;
    private static boolean NORMALIZE_CASE = true;
    public static final String PLUGIN_ID = "org.eclipse.compare";
    private static final String BINARY_TYPE = "binary";
    private static final String STREAM_MERGER_EXTENSION_POINT = "streamMergers";
    private static final String STREAM_MERGER = "streamMerger";
    private static final String STREAM_MERGER_ID_ATTRIBUTE = "streamMergerId";
    private static final String STRUCTURE_CREATOR_EXTENSION_POINT = "structureCreators";
    private static final String STRUCTURE_CREATOR = "structureCreator";
    private static final String STRUCTURE_CREATOR_ID_ATTRIBUTE = "structureCreatorId";
    private static final String VIEWER_TAG = "viewer";
    private static final String FILTER_TAG = "filter";
    private static final String STRUCTURE_MERGE_VIEWER_EXTENSION_POINT = "structureMergeViewers";
    private static final String STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE = "structureMergeViewerId";
    private static final String CONTENT_MERGE_VIEWER_EXTENSION_POINT = "contentMergeViewers";
    private static final String COMPARE_FILTER_EXTENTION_POINT = "compareFilters";
    private static final String COMPARE_FILTER_ID_ATTRIBUTE = "filterId";
    private static final String CONTENT_MERGE_VIEWER_ID_ATTRIBUTE = "contentMergeViewerId";
    private static final String CONTENT_VIEWER_EXTENSION_POINT = "contentViewers";
    private static final String CONTENT_VIEWER_ID_ATTRIBUTE = "contentViewerId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private static final String STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME = "StructureViewerAliases";
    private static final IContentTypeManager fgContentTypeManager = Platform.getContentTypeManager();
    public static final int NO_DIFFERENCE = 10000;
    private static CompareUIPlugin fgComparePlugin;
    private static Map<String, Image> fgImages;
    private static Map<String, ImageDescriptor> fgImageDescriptors;
    private static Map<ImageDescriptor, Image> fgImages2;
    private static List<Image> fgDisposeOnShutdownImages;
    private ResourceBundle fResourceBundle;
    private boolean fRegistriesInitialized;
    private CompareRegistry<StreamMergerDescriptor> fStreamMergers = new CompareRegistry();
    private CompareRegistry<StructureCreatorDescriptor> fStructureCreators = new CompareRegistry();
    private CompareRegistry<ViewerDescriptor> fStructureMergeViewers = new CompareRegistry();
    private CompareRegistry<ViewerDescriptor> fContentViewers = new CompareRegistry();
    private CompareRegistry<ViewerDescriptor> fContentMergeViewers = new CompareRegistry();
    private CompareRegistry<CompareFilterDescriptor> fCompareFilters = new CompareRegistry();
    private Map<String, String> fStructureViewerAliases;
    private CompareResourceFilter fFilter;
    private IPropertyChangeListener fPropertyChangeListener;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;

    static {
        fgImages = new Hashtable<String, Image>(10);
        fgImageDescriptors = new Hashtable<String, ImageDescriptor>(10);
        fgImages2 = new Hashtable<ImageDescriptor, Image>(10);
        fgDisposeOnShutdownImages = new ArrayList<Image>();
    }

    public CompareUIPlugin() {
        Assert.isTrue((fgComparePlugin == null ? 1 : 0) != 0);
        fgComparePlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", PLUGIN_ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.DEBUG_OPTIONS_LISTENER, properties);
        ComparePlugin.getDefault().setCappingDisabled(this.getPreferenceStore().getBoolean("org.eclipse.compare.CappingDisable"));
    }

    public void stop(BundleContext context) throws Exception {
        IPreferenceStore ps = this.getPreferenceStore();
        this.rememberAliases(ps);
        if (this.fPropertyChangeListener != null) {
            ps.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        super.stop(context);
        if (fgDisposeOnShutdownImages != null) {
            for (Image img : fgDisposeOnShutdownImages) {
                if (img.isDisposed()) continue;
                img.dispose();
            }
            fgImages = null;
        }
        if (this.debugRegistration != null) {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
        }
    }

    public static CompareUIPlugin getDefault() {
        return fgComparePlugin;
    }

    public ResourceBundle getResourceBundle() {
        if (this.fResourceBundle == null) {
            this.fResourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        return this.fResourceBundle;
    }

    public static String getPluginId() {
        return CompareUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    private void initializeRegistries() {
        if (!this.fRegistriesInitialized) {
            this.registerExtensions();
            this.fRegistriesInitialized = true;
        }
    }

    private void registerExtensions() {
        String name;
        IConfigurationElement element;
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, STREAM_MERGER_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (STREAM_MERGER.equals(element.getName())) {
                this.fStreamMergers.register(element, new StreamMergerDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStreamMergers.createBinding(element, STREAM_MERGER_ID_ATTRIBUTE);
            }
            ++n2;
        }
        iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_CREATOR_EXTENSION_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!STRUCTURE_CREATOR.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, STRUCTURE_CREATOR));
                }
                this.fStructureCreators.register(element, new StructureCreatorDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStructureCreators.createBinding(element, STRUCTURE_CREATOR_ID_ATTRIBUTE);
            }
            ++n2;
        }
        iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_MERGE_VIEWER_EXTENSION_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fStructureMergeViewers.register(element, new ViewerDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStructureMergeViewers.createBinding(element, STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE);
            }
            ++n2;
        }
        iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_MERGE_VIEWER_EXTENSION_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fContentMergeViewers.register(element, new ViewerDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fContentMergeViewers.createBinding(element, CONTENT_MERGE_VIEWER_ID_ATTRIBUTE);
            }
            ++n2;
        }
        iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, COMPARE_FILTER_EXTENTION_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!FILTER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, FILTER_TAG));
                }
                this.fCompareFilters.register(element, new CompareFilterDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fCompareFilters.createBinding(element, COMPARE_FILTER_ID_ATTRIBUTE);
            }
            ++n2;
        }
        iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_VIEWER_EXTENSION_POINT);
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fContentViewers.register(element, new ViewerDescriptor(element));
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fContentViewers.createBinding(element, CONTENT_VIEWER_ID_ATTRIBUTE);
            }
            ++n2;
        }
    }

    public static IWorkbench getActiveWorkbench() {
        CompareUIPlugin plugin = CompareUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = CompareUIPlugin.getActiveWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static void disposeOnShutdown(Image image) {
        if (image != null) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor, boolean activate) {
        IPreferenceStore ps;
        CompareConfiguration configuration = input.getCompareConfiguration();
        if (configuration != null && (ps = configuration.getPreferenceStore()) != null) {
            configuration.setProperty("USE_OUTLINE_VIEW", ps.getBoolean("org.eclipse.compare.UseOutlineView"));
        }
        if (input.canRunAsJob()) {
            this.openEditorInBackground(input, page, editor, activate);
        } else if (this.compareResultOK(input, null)) {
            this.internalOpenEditor(input, page, editor, activate);
        }
    }

    private void openEditorInBackground(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor, boolean activate) {
        this.internalOpenEditor(input, page, editor, activate);
    }

    private void internalOpenEditor(CompareEditorInput input, IWorkbenchPage wp, IReusableEditor editor, boolean activate) {
        Runnable runnable = () -> {
            if (editor != null && !editor.getSite().getShell().isDisposed()) {
                editor.setInput((IEditorInput)input);
                return;
            }
            IWorkbenchPage page = wp;
            if (page == null) {
                page = CompareUIPlugin.getActivePage();
            }
            if (page != null) {
                try {
                    page.openEditor((IEditorInput)input, COMPARE_EDITOR, activate);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)e.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)Utilities.getString("CompareUIPlugin.noActiveWorkbenchPage"));
            }
        };
        this.syncExec(runnable);
    }

    public void openCompareDialog(CompareEditorInput input) {
        if (this.compareResultOK(input, null)) {
            this.internalOpenDialog(input);
        }
    }

    public IStatus prepareInput(CompareEditorInput input, IProgressMonitor monitor) {
        try {
            input.run(monitor);
            String message = input.getMessage();
            if (message != null) {
                return new Status(4, PLUGIN_ID, 0, message, null);
            }
            if (input.getCompareResult() == null) {
                return new Status(4, PLUGIN_ID, 10000, Utilities.getString("CompareUIPlugin.noDifferences"), null);
            }
            return Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        catch (InvocationTargetException e) {
            return new Status(4, PLUGIN_ID, 0, Utilities.getString("CompareUIPlugin.compareFailed"), e.getTargetException());
        }
    }

    public boolean compareResultOK(CompareEditorInput input, IRunnableContext context) {
        Shell shell;
        block6: {
            shell = CompareUIPlugin.getShell();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message == null) break block6;
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)message);
            return false;
        }
        try {
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)Utilities.getString("CompareUIPlugin.dialogTitle"), (String)Utilities.getString("CompareUIPlugin.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }

    private static void registerImage(String type, Image image, boolean dispose) {
        fgImages.put(CompareUIPlugin.normalizeCase(type), image);
        if (image != null && dispose) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public static void registerImageDescriptor(String type, ImageDescriptor descriptor) {
        fgImageDescriptors.put(CompareUIPlugin.normalizeCase(type), descriptor);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        if (fgComparePlugin == null) {
            return null;
        }
        IPath path = Utilities.getIconPath(null).append(relativePath);
        URL url = FileLocator.find((Bundle)fgComparePlugin.getBundle(), (IPath)path, null);
        if (url == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static Image getImage(String type) {
        type = CompareUIPlugin.normalizeCase(type);
        boolean dispose = false;
        Image image = null;
        if (type != null) {
            image = fgImages.get(type);
        }
        if (image == null) {
            ImageDescriptor id = fgImageDescriptors.get(type);
            if (id != null) {
                image = id.createImage();
                dispose = true;
            }
            if (image == null) {
                if (fgComparePlugin != null) {
                    if ("FOLDER".equals(type)) {
                        image = CompareUIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    } else {
                        image = CompareUIPlugin.createWorkbenchImage(type);
                        dispose = true;
                    }
                } else {
                    id = fgImageDescriptors.get(CompareUIPlugin.normalizeCase("file"));
                    image = id.createImage();
                    dispose = true;
                }
            }
            if (image != null) {
                CompareUIPlugin.registerImage(type, image, dispose);
            }
        }
        return image;
    }

    public static Image getImage(IAdaptable adaptable) {
        IWorkbenchAdapter o;
        ImageDescriptor id;
        if (adaptable != null && (id = (o = (IWorkbenchAdapter)Adapters.adapt((Object)adaptable, IWorkbenchAdapter.class)).getImageDescriptor((Object)adaptable)) != null) {
            Image image = fgImages2.get(id);
            if (image == null) {
                image = id.createImage();
                try {
                    fgImages2.put(id, image);
                }
                catch (NullPointerException nullPointerException) {}
                fgDisposeOnShutdownImages.add(image);
            }
            return image;
        }
        return null;
    }

    private static Image createWorkbenchImage(String type) {
        IEditorRegistry er = CompareUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        ImageDescriptor id = er.getImageDescriptor("foo." + type);
        return id.createImage();
    }

    public StructureCreatorDescriptor getStructureCreator(String type) {
        this.initializeRegistries();
        return this.fStructureCreators.search(type);
    }

    public IStreamMerger createStreamMerger(String type) {
        this.initializeRegistries();
        StreamMergerDescriptor descriptor = this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public IStreamMerger createStreamMerger(IContentType type) {
        this.initializeRegistries();
        StreamMergerDescriptor descriptor = this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public ViewerDescriptor[] findStructureViewerDescriptor(Viewer oldViewer, ICompareInput input, CompareConfiguration configuration) {
        if (input == null) {
            return null;
        }
        if (input == null || input.getLeft() == null || input.getRight() == null) {
            return null;
        }
        LinkedHashSet<ViewerDescriptor> result = new LinkedHashSet<ViewerDescriptor>();
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fStructureMergeViewers.searchAll(ctype);
            if (list != null) {
                result.addAll(list);
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            String alias;
            type = CompareUIPlugin.normalizeCase(types[0]);
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fStructureMergeViewers.searchAll(type);
            if (list != null) {
                result.addAll(list);
            }
            if ((alias = this.getStructureViewerAlias(type)) != null && (list = this.fStructureMergeViewers.searchAll(alias)) != null) {
                result.addAll(list);
            }
        }
        return result.size() > 0 ? result.toArray(new ViewerDescriptor[0]) : null;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
        ViewerDescriptor[] descriptors = this.findStructureViewerDescriptor(oldViewer, input, configuration);
        if (descriptors == null || descriptors.length == 0) {
            IStructureCreator sc;
            IContentType ctype = CompareUIPlugin.getCommonType(input);
            String[] types = CompareUIPlugin.getTypes(input);
            String type = null;
            if (CompareUIPlugin.isHomogenous(types)) {
                type = CompareUIPlugin.normalizeCase(types[0]);
            }
            this.initializeRegistries();
            StructureCreatorDescriptor scc = this.fStructureCreators.search(ctype);
            if (scc == null && type != null) {
                scc = this.getStructureCreator(type);
            }
            if (scc != null && (sc = scc.createStructureCreator()) != null) {
                StructureDiffViewer sdv = new StructureDiffViewer(parent, configuration);
                sdv.setStructureCreator(sc);
                return sdv;
            }
            return null;
        }
        return CompareUIPlugin.getViewer(descriptors[0], oldViewer, parent, configuration);
    }

    public CompareFilterDescriptor[] findCompareFilters(Object in) {
        Collection<Object> contentTypes = this.getContentTypes(in);
        if (contentTypes == null) {
            return new CompareFilterDescriptor[0];
        }
        LinkedHashSet<CompareFilterDescriptor> result = new LinkedHashSet<CompareFilterDescriptor>();
        for (Object ct : contentTypes) {
            List<CompareFilterDescriptor> list;
            if (ct instanceof IContentType) {
                list = this.fCompareFilters.searchAll((IContentType)ct);
                if (list == null) continue;
                result.addAll(list);
                continue;
            }
            if (!(ct instanceof String) || (list = this.fCompareFilters.searchAll((String)ct)) == null) continue;
            result.addAll(list);
        }
        ArrayList list = new ArrayList(result);
        Collections.sort(list, (left, right) -> left.getFilterId().compareTo(right.getFilterId()));
        return result.toArray(new CompareFilterDescriptor[result.size()]);
    }

    private Collection<Object> getContentTypes(Object in) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (in instanceof IStreamContentAccessor) {
            String type = "txt";
            if (in instanceof ITypedElement) {
                String ty;
                ITypedElement tin = (ITypedElement)in;
                IContentType ct = CompareUIPlugin.getContentType(tin);
                if (ct != null) {
                    result.add(ct);
                }
                if ((ty = tin.getType()) != null) {
                    type = ty;
                }
                result.add(type);
            }
            return result;
        }
        if (!(in instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)in;
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            result.add(ctype);
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            String[] stringArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                String t = stringArray[n3];
                if (!"???".equals(t)) {
                    ++n;
                    if (type == null) {
                        type = t;
                    }
                }
                ++n3;
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null) {
            result.add(type);
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            boolean left_text;
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean bl = left_text = leftType != null && "txt".equals(leftType);
            if (rightType != null && !right_text || leftType != null && !left_text) {
                result.add(BINARY_TYPE);
            }
            result.add("txt");
        }
        return result;
    }

    public ViewerDescriptor[] findContentViewerDescriptor(Viewer oldViewer, Object in, CompareConfiguration cc) {
        LinkedHashSet<ViewerDescriptor> result = new LinkedHashSet<ViewerDescriptor>();
        if (in instanceof IStreamContentAccessor) {
            String type = "txt";
            if (in instanceof ITypedElement) {
                String ty;
                ITypedElement tin = (ITypedElement)in;
                IContentType ct = CompareUIPlugin.getContentType(tin);
                if (ct != null) {
                    this.initializeRegistries();
                    List<ViewerDescriptor> list = this.fContentViewers.searchAll(ct);
                    if (list != null) {
                        result.addAll(list);
                    }
                }
                if ((ty = tin.getType()) != null) {
                    type = ty;
                }
            }
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fContentViewers.searchAll(type);
            if (list != null) {
                result.addAll(list);
            }
            result.add(this.fContentViewers.search(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text")));
            return result.toArray(new ViewerDescriptor[0]);
        }
        if (!(in instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)in;
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fContentMergeViewers.searchAll(ctype);
            if (list != null) {
                result.addAll(list);
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            String[] stringArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                String t = stringArray[n3];
                if (!"???".equals(t)) {
                    ++n;
                    if (type == null) {
                        type = t;
                    }
                }
                ++n3;
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fContentMergeViewers.searchAll(type);
            if (list != null) {
                result.addAll(list);
            }
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            List<ViewerDescriptor> list;
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean left_text = leftType != null && "txt".equals(leftType);
            this.initializeRegistries();
            if ((rightType != null && !right_text || leftType != null && !left_text) && (list = this.fContentMergeViewers.searchAll(BINARY_TYPE)) != null) {
                result.addAll(list);
            }
            if ((list = this.fContentMergeViewers.searchAll("txt")) != null) {
                result.addAll(list);
            }
            return result.toArray(new ViewerDescriptor[0]);
        }
        return result.isEmpty() ? null : result.toArray(new ViewerDescriptor[0]);
    }

    public Viewer findContentViewer(Viewer oldViewer, Object in, Composite parent, CompareConfiguration cc) {
        ViewerDescriptor[] descriptors = this.findContentViewerDescriptor(oldViewer, in, cc);
        return CompareUIPlugin.getViewer(descriptors != null ? descriptors[0] : null, oldViewer, parent, cc);
    }

    private static Viewer getViewer(Object descriptor, Viewer oldViewer, Composite parent, CompareConfiguration cc) {
        if (descriptor instanceof IViewerDescriptor) {
            return ((IViewerDescriptor)descriptor).createViewer(oldViewer, parent, cc);
        }
        return null;
    }

    private static String[] getTypes(ICompareInput input) {
        String type;
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ArrayList<String> tmp = new ArrayList<String>();
        if (ancestor != null && (type = ancestor.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (left != null && (type = left.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (right != null && (type = right.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private static IContentType getContentType(ITypedElement element) {
        IContentType ct;
        String name;
        block18: {
            IResource resource;
            if (element == null) {
                return null;
            }
            name = element.getName();
            ct = null;
            if (element instanceof IResourceProvider && (resource = ((IResourceProvider)((Object)element)).getResource()) instanceof IFile) {
                try {
                    IContentDescription contentDesc = ((IFile)resource).getContentDescription();
                    return contentDesc != null ? contentDesc.getContentType() : null;
                }
                catch (CoreException coreException) {}
            }
            if (element instanceof IStreamContentAccessor) {
                IStreamContentAccessor isa = (IStreamContentAccessor)((Object)element);
                try {
                    InputStream is = isa.getContents();
                    if (is == null) break block18;
                    BufferedInputStream bis = new BufferedInputStream(is);
                    try {
                        try {
                            ct = fgContentTypeManager.findContentTypeFor(is, name);
                        }
                        catch (IOException iOException) {
                            try {
                                ((InputStream)bis).close();
                            }
                            catch (IOException iOException2) {}
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)bis).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)bis).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (CoreException coreException) {}
            }
        }
        if (ct == null) {
            ct = fgContentTypeManager.findContentTypeFor(name);
        }
        return ct;
    }

    private static boolean isHomogenous(String[] types) {
        switch (types.length) {
            case 1: {
                return true;
            }
            case 2: {
                return types[0].equals(types[1]);
            }
            case 3: {
                return types[0].equals(types[1]) && types[1].equals(types[2]);
            }
        }
        return false;
    }

    private static IContentType getCommonType(ICompareInput input) {
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        int n = 0;
        IContentType[] types = new IContentType[3];
        IContentType type = null;
        if (ancestor != null && (type = CompareUIPlugin.getContentType(ancestor)) != null) {
            types[n++] = type;
        }
        if ((type = CompareUIPlugin.getContentType(left)) != null) {
            types[n++] = type;
        }
        if ((type = CompareUIPlugin.getContentType(right)) != null) {
            types[n++] = type;
        }
        IContentType result = null;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return types[0];
            }
            case 2: {
                if (types[0].equals(types[1])) {
                    return types[0];
                }
                IContentType[] s0 = CompareUIPlugin.toFullPath(types[0]);
                IContentType[] s1 = CompareUIPlugin.toFullPath(types[1]);
                int i = 0;
                while (i < Math.min(s0.length, s1.length)) {
                    if (!s0[i].equals(s1[i])) break;
                    result = s0[i];
                    ++i;
                }
                return result;
            }
            case 3: {
                if (types[0].equals(types[1]) && types[1].equals(types[2])) {
                    return types[0];
                }
                IContentType[] s0 = CompareUIPlugin.toFullPath(types[0]);
                IContentType[] s1 = CompareUIPlugin.toFullPath(types[1]);
                IContentType[] s2 = CompareUIPlugin.toFullPath(types[2]);
                int i = 0;
                while (i < Math.min(Math.min(s0.length, s1.length), s2.length)) {
                    if (!s0[i].equals(s1[i]) || !s1[i].equals(s2[i])) break;
                    result = s0[i];
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    private static IContentType[] toFullPath(IContentType ct) {
        ArrayList<IContentType> l = new ArrayList<IContentType>();
        while (ct != null) {
            l.add(0, ct);
            ct = ct.getBaseType();
        }
        return l.toArray(new IContentType[l.size()]);
    }

    /*
     * Exception decompiling
     */
    private static String guessType(ITypedElement input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String normalizeCase(String s) {
        if (NORMALIZE_CASE && s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    private String getStructureViewerAlias(String type) {
        return this.getStructureViewerAliases().get(type);
    }

    public void addStructureViewerAlias(String type, String alias) {
        this.getStructureViewerAliases().put(CompareUIPlugin.normalizeCase(alias), CompareUIPlugin.normalizeCase(type));
    }

    private Map<String, String> getStructureViewerAliases() {
        if (this.fStructureViewerAliases == null) {
            this.fStructureViewerAliases = new Hashtable<String, String>(10);
            String aliases = this.getPreferenceStore().getString(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME);
            if (aliases != null && aliases.length() > 0) {
                StringTokenizer st = new StringTokenizer(aliases, " ");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    int pos = pair.indexOf(46);
                    if (pos <= 0) continue;
                    String key = pair.substring(0, pos);
                    String alias = pair.substring(pos + 1);
                    this.fStructureViewerAliases.put(key, alias);
                }
            }
        }
        return this.fStructureViewerAliases;
    }

    public void removeAllStructureViewerAliases(String type) {
        if (this.fStructureViewerAliases == null) {
            return;
        }
        String t = CompareUIPlugin.normalizeCase(type);
        Set<Map.Entry<String, String>> entrySet = this.fStructureViewerAliases.entrySet();
        Iterator<Map.Entry<String, String>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getValue().equals(t)) continue;
            iter.remove();
        }
    }

    private void rememberAliases(IPreferenceStore ps) {
        if (this.fStructureViewerAliases == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> entry : this.fStructureViewerAliases.entrySet()) {
            String key = entry.getKey();
            String alias = entry.getValue();
            buffer.append(key);
            buffer.append('.');
            buffer.append(alias);
            buffer.append(' ');
        }
        ps.setValue(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME, buffer.toString());
    }

    public boolean filter(String name, boolean isFolder, boolean isArchive) {
        if (this.fFilter == null) {
            this.fFilter = new CompareResourceFilter();
            IPreferenceStore ps = this.getPreferenceStore();
            this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
            this.fPropertyChangeListener = event -> {
                if ("org.eclipse.compare.PathFilter".equals(event.getProperty())) {
                    this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
                }
            };
            ps.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        return this.fFilter.filter(name, isFolder, isArchive);
    }

    private void internalOpenDialog(CompareEditorInput input) {
        Runnable runnable = () -> {
            CompareDialog dialog = new CompareDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), input);
            dialog.open();
        };
        this.syncExec(runnable);
    }

    private void syncExec(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected void handleNoDifference() {
        Runnable runnable = () -> MessageDialog.openInformation((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.dialogTitle"), (String)Utilities.getString("CompareUIPlugin.noDifferences"));
        this.syncExec(runnable);
    }

    public static IEditorPart[] getDirtyEditors() {
        IWorkbenchWindow[] windows;
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CompareUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart[] editors;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                int n5 = editors.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorPart ep = iEditorPartArray[n6];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, message, null));
    }

    public static void log(Throwable e) {
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, CompareMessages.ComparePlugin_internal_error, e));
    }

    public static void log(IStatus status) {
        CompareUIPlugin.getDefault().getLog().log(status);
    }

    String findContentTypeNameOrType(ICompareInput input, ViewerDescriptor vd, CompareConfiguration cc) {
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fContentMergeViewers.searchAll(ctype);
            if (list != null && list.contains(vd)) {
                return ctype.getName();
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            String[] stringArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                String t = stringArray[n3];
                if (!"???".equals(t)) {
                    ++n;
                    if (type == null) {
                        type = t;
                    }
                }
                ++n3;
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fContentMergeViewers.searchAll(type);
            if (list != null && list.contains(vd)) {
                return type;
            }
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            List<ViewerDescriptor> list;
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean left_text = leftType != null && "txt".equals(leftType);
            this.initializeRegistries();
            if ((rightType != null && !right_text || leftType != null && !left_text) && (list = this.fContentMergeViewers.searchAll(BINARY_TYPE)) != null && list.contains(vd)) {
                return type;
            }
            list = this.fContentMergeViewers.searchAll("txt");
            if (list != null && list.contains(vd)) {
                return type;
            }
        }
        return null;
    }

    String findStructureTypeNameOrType(ICompareInput input, ViewerDescriptor vd, CompareConfiguration cc) {
        if (input == null) {
            return null;
        }
        if (input == null || input.getLeft() == null || input.getRight() == null) {
            return null;
        }
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fStructureMergeViewers.searchAll(ctype);
            if (list != null && list.contains(vd)) {
                return ctype.getName();
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = CompareUIPlugin.normalizeCase(types[0]);
            this.initializeRegistries();
            List<ViewerDescriptor> list = this.fStructureMergeViewers.searchAll(type);
            if (list != null && list.contains(vd)) {
                return type;
            }
            String alias = this.getStructureViewerAlias(type);
            if (alias != null && (list = this.fStructureMergeViewers.searchAll(alias)) != null && list.contains(vd)) {
                return alias;
            }
        }
        return null;
    }

    static class CompareRegistry<T> {
        private static final String ID_ATTRIBUTE = "id";
        private static final String EXTENSIONS_ATTRIBUTE = "extensions";
        private static final String CONTENT_TYPE_ID_ATTRIBUTE = "contentTypeId";
        private HashMap<String, T> fIdMap;
        private HashMap<String, List<T>> fExtensionMap;
        private HashMap<IContentType, List<T>> fContentTypeBindings;

        CompareRegistry() {
        }

        void register(IConfigurationElement element, T data) {
            String types;
            String id = element.getAttribute(ID_ATTRIBUTE);
            if (id != null) {
                if (this.fIdMap == null) {
                    this.fIdMap = new HashMap();
                }
                this.fIdMap.put(id, data);
            }
            if ((types = element.getAttribute(EXTENSIONS_ATTRIBUTE)) != null) {
                if (this.fExtensionMap == null) {
                    this.fExtensionMap = new HashMap();
                }
                StringTokenizer tokenizer = new StringTokenizer(types, ",");
                while (tokenizer.hasMoreElements()) {
                    String extension = tokenizer.nextToken().trim();
                    List<T> l = this.fExtensionMap.get(CompareUIPlugin.normalizeCase(extension));
                    if (l == null) {
                        l = new ArrayList<T>();
                        this.fExtensionMap.put(CompareUIPlugin.normalizeCase(extension), l);
                    }
                    l.add(data);
                }
            }
        }

        void createBinding(IConfigurationElement element, String idAttributeName) {
            String type = element.getAttribute(CONTENT_TYPE_ID_ATTRIBUTE);
            String id = element.getAttribute(idAttributeName);
            if (id == null) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetIdAttributeMissing", idAttributeName));
            }
            if (type != null && id != null && this.fIdMap != null) {
                T o = this.fIdMap.get(id);
                if (o != null) {
                    IContentType ct = fgContentTypeManager.getContentType(type);
                    if (ct != null) {
                        List<T> l;
                        if (this.fContentTypeBindings == null) {
                            this.fContentTypeBindings = new HashMap();
                        }
                        if ((l = this.fContentTypeBindings.get(ct)) == null) {
                            l = new ArrayList<T>();
                            this.fContentTypeBindings.put(ct, l);
                        }
                        l.add(o);
                    } else {
                        CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.contentTypeNotFound", type));
                    }
                } else {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetNotFound", id));
                }
            }
        }

        T search(IContentType type) {
            List<T> list = this.searchAll(type);
            return list != null ? (T)list.get(0) : null;
        }

        List<T> searchAll(IContentType type) {
            if (this.fContentTypeBindings != null) {
                while (type != null) {
                    List<T> data = this.fContentTypeBindings.get(type);
                    if (data != null) {
                        return data;
                    }
                    type = type.getBaseType();
                }
            }
            return null;
        }

        T search(String extension) {
            List<T> list = this.searchAll(extension);
            return list != null ? (T)list.get(0) : null;
        }

        List<T> searchAll(String extension) {
            if (this.fExtensionMap != null) {
                return this.fExtensionMap.get(CompareUIPlugin.normalizeCase(extension));
            }
            return null;
        }
    }
}

