/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.recording;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;

public enum RecordingContextManager {
    Instance;

    public static final String CONTROL_PANEL_CONTEXT_ID = "org.eclipse.rcptt.ui.contexts.recording";
    public static final String RECORDING_COMMAND_ID = "org.eclipse.rcptt.ui.commands.recording.recordMode";
    public static final String ASSERTING_COMMAND_ID = "org.eclipse.rcptt.ui.commands.recording.assertMode";
    public static final String START_RECORD_COMMAND_ID = "org.eclipse.rcptt.ui.commands.recording.startRecording";
    public static final String STOP_RECORD_COMMAND_ID = "org.eclipse.rcptt.ui.commands.recording.stopRecording";
    public static final String REPLAY_COMMAND_ID = "org.eclipse.rcptt.ui.commands.recording.replay";
    private final WritableValue recordModeShortcutsObservable = new WritableValue(null, TriggerSequence[].class);
    private final WritableValue assertModeShortcutsObservable = new WritableValue(null, TriggerSequence[].class);
    private final WritableValue startRecordShortcutsObservable = new WritableValue(null, TriggerSequence[].class);
    private final WritableValue stopRecordShortcutsObservable = new WritableValue(null, TriggerSequence[].class);
    private final WritableValue replayShortcutsObservable = new WritableValue(null, TriggerSequence[].class);
    private final IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
    private final IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
    private IContextActivation contextActivation;

    private void updateTriggerSequences() {
        this.updateTriggerSequence(RECORDING_COMMAND_ID, this.recordModeShortcutsObservable);
        this.updateTriggerSequence(ASSERTING_COMMAND_ID, this.assertModeShortcutsObservable);
        this.updateTriggerSequence(START_RECORD_COMMAND_ID, this.startRecordShortcutsObservable);
        this.updateTriggerSequence(STOP_RECORD_COMMAND_ID, this.stopRecordShortcutsObservable);
        this.updateTriggerSequence(REPLAY_COMMAND_ID, this.replayShortcutsObservable);
    }

    private void updateTriggerSequence(String commandId, WritableValue value) {
        TriggerSequence[] sequences = this.bindingService.getActiveBindingsFor(commandId);
        value.setValue((Object)sequences);
    }

    public synchronized void activateContext() {
        if (this.contextActivation == null) {
            this.contextActivation = this.contextService.activateContext(CONTROL_PANEL_CONTEXT_ID);
            this.bindingService.addBindingManagerListener((IBindingManagerListener)new BindingServiceListener());
            this.updateTriggerSequences();
        }
    }

    public synchronized void deactivateContext() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
            this.bindingService.removeBindingManagerListener((IBindingManagerListener)new BindingServiceListener());
            this.updateTriggerSequences();
        }
    }

    public TriggerSequence[] getRecordModeShortcuts() {
        return (TriggerSequence[])this.recordModeShortcutsObservable.getValue();
    }

    public TriggerSequence[] getAssertModeShortcuts() {
        return (TriggerSequence[])this.assertModeShortcutsObservable.getValue();
    }

    public TriggerSequence[] getStartRecordShortcuts() {
        return (TriggerSequence[])this.startRecordShortcutsObservable.getValue();
    }

    public TriggerSequence[] getStopRecordShortcuts() {
        return (TriggerSequence[])this.stopRecordShortcutsObservable.getValue();
    }

    public TriggerSequence[] getReplayShortcuts() {
        return (TriggerSequence[])this.replayShortcutsObservable.getValue();
    }

    public IObservableValue observeRecordModeShortcuts() {
        return this.recordModeShortcutsObservable;
    }

    public IObservableValue observeAssertModeShortcuts() {
        return this.assertModeShortcutsObservable;
    }

    public IObservableValue observeStartRecordShortcuts() {
        return this.startRecordShortcutsObservable;
    }

    public IObservableValue observeStopRecordShortcuts() {
        return this.stopRecordShortcutsObservable;
    }

    public IObservableValue observeReplayShortcuts() {
        return this.replayShortcutsObservable;
    }

    private final class BindingServiceListener
    implements IBindingManagerListener {
        private BindingServiceListener() {
        }

        public void bindingManagerChanged(BindingManagerEvent event) {
            RecordingContextManager.this.updateTriggerSequences();
        }
    }
}

