/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.recording;

import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.rcptt.core.recording.IRecordingMonitor;
import org.eclipse.rcptt.core.recording.NetworkRecorder;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.swt.widgets.Event;

public class UiNetworkRecorder
extends NetworkRecorder {
    private static final String RECORD_MODE_SHORTCUTS_FEATURE = "record_mode_shortcuts";
    private static final String ASSERT_MODE_SHORTCUTS_FEATURE = "assert_mode_shortcuts";
    private static final String START_RECORD_SHORTCUTS_FEATURE = "start_record_shortcuts";
    private static final String STOP_RECORD_SHORTCUTS_FEATURE = "stop_record_shortcuts";
    private static final String REPLAY_SHORTCUTS_FEATURE = "replay_shortcuts";
    private TriggerSequence[] assertModeShortcuts;
    private TriggerSequence[] recordingModeShortcuts;
    private TriggerSequence[] startRecordShortcuts;
    private TriggerSequence[] stopRecordShortcuts;
    private TriggerSequence[] replayShortcuts;

    public UiNetworkRecorder(String host, int port, IRecordingMonitor monitor) {
        super(host, port, monitor);
    }

    protected boolean isAssertModeRequest(Type command) {
        return this.isShortcutsRequest(command, this.assertModeShortcuts);
    }

    protected boolean isRecordingModeRequest(Type command) {
        return this.isShortcutsRequest(command, this.recordingModeShortcuts);
    }

    protected boolean isStartRecordRequest(Type command) {
        return this.isShortcutsRequest(command, this.startRecordShortcuts);
    }

    protected boolean isStopRecordRequest(Type command) {
        return this.isShortcutsRequest(command, this.stopRecordShortcuts);
    }

    protected boolean isReplayRequest(Type command) {
        return this.isShortcutsRequest(command, this.replayShortcuts);
    }

    private boolean isShortcutsRequest(Type command, TriggerSequence[] shortcuts) {
        Event e = new Event();
        e.character = command.getCharacter();
        e.keyCode = command.getCode();
        e.stateMask = command.getState();
        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)e);
        KeySequence sequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
        if (this.assertModeShortcuts != null) {
            TriggerSequence[] triggerSequenceArray = shortcuts;
            int n = shortcuts.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerSequence s = triggerSequenceArray[n2];
                if (sequence.equals((Object)s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public synchronized void setAssertModeShortcuts(TriggerSequence[] shortcuts) {
        this.assertModeShortcuts = shortcuts;
        StringBuilder builder = new StringBuilder();
        TriggerSequence[] triggerSequenceArray = shortcuts;
        int n = shortcuts.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence s = triggerSequenceArray[n2];
            builder.append(s).append("\n");
            ++n2;
        }
        this.setFeature(ASSERT_MODE_SHORTCUTS_FEATURE, builder.toString());
    }

    public void setRecordModeShortcuts(TriggerSequence[] shortcuts) {
        this.recordingModeShortcuts = shortcuts;
        StringBuilder builder = new StringBuilder();
        TriggerSequence[] triggerSequenceArray = shortcuts;
        int n = shortcuts.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence s = triggerSequenceArray[n2];
            builder.append(s).append("\n");
            ++n2;
        }
        this.setFeature(RECORD_MODE_SHORTCUTS_FEATURE, builder.toString());
    }

    public void setStartRecordShortcuts(TriggerSequence[] shortcuts) {
        this.startRecordShortcuts = shortcuts;
        StringBuilder builder = new StringBuilder();
        TriggerSequence[] triggerSequenceArray = shortcuts;
        int n = shortcuts.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence s = triggerSequenceArray[n2];
            builder.append(s).append("\n");
            ++n2;
        }
        this.setFeature(START_RECORD_SHORTCUTS_FEATURE, builder.toString());
    }

    public void setStopRecordShortcuts(TriggerSequence[] shortcuts) {
        this.stopRecordShortcuts = shortcuts;
        StringBuilder builder = new StringBuilder();
        TriggerSequence[] triggerSequenceArray = shortcuts;
        int n = shortcuts.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence s = triggerSequenceArray[n2];
            builder.append(s).append("\n");
            ++n2;
        }
        this.setFeature(STOP_RECORD_SHORTCUTS_FEATURE, builder.toString());
    }

    public void setReplayShortcuts(TriggerSequence[] shortcuts) {
        this.replayShortcuts = shortcuts;
        StringBuilder builder = new StringBuilder();
        TriggerSequence[] triggerSequenceArray = shortcuts;
        int n = shortcuts.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence s = triggerSequenceArray[n2];
            builder.append(s).append("\n");
            ++n2;
        }
        this.setFeature(REPLAY_SHORTCUTS_FEATURE, builder.toString());
    }
}

