/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.factories;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffWorkbenchAdapter;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.GitHistoryPageSource;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeWorkbenchAdapter;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitModelWorkbenchAdapter;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitObjectMapping;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.IShowInSource;

public class GitAdapterFactory
implements IAdapterFactory {
    private GitModelWorkbenchAdapter gitModelWorkbenchAdapter;
    private static final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        ResourceMapping m;
        IHistoryView historyView;
        IHistoryPage historyPage;
        if (adapterType.isAssignableFrom(IHistoryPageSource.class)) {
            return adapterType.cast((Object)GitHistoryPageSource.INSTANCE);
        }
        if (IWorkbenchAdapter.class == adapterType) {
            if (adaptableObject instanceof RepositoryTreeNode) {
                return adapterType.cast((Object)RepositoryTreeNodeWorkbenchAdapter.INSTANCE);
            }
            if (adaptableObject instanceof FileDiff) {
                return adapterType.cast((Object)FileDiffWorkbenchAdapter.INSTANCE);
            }
            if (this.gitModelWorkbenchAdapter == null) {
                this.gitModelWorkbenchAdapter = new GitModelWorkbenchAdapter();
            }
            return adapterType.cast(this.gitModelWorkbenchAdapter);
        }
        if (adaptableObject instanceof IHistoryView && IShowInSource.class == adapterType && (historyPage = (historyView = (IHistoryView)adaptableObject).getHistoryPage()) instanceof GitHistoryPage) {
            return adapterType.cast(historyPage);
        }
        if (adaptableObject instanceof IURIEditorInput && adapterType == Repository.class) {
            return adapterType.cast(GitAdapterFactory.getRepository((IURIEditorInput)adaptableObject));
        }
        if (adaptableObject instanceof IURIEditorInput && adapterType == File.class) {
            return adapterType.cast(GitAdapterFactory.getFile((IURIEditorInput)adaptableObject));
        }
        if (adaptableObject instanceof GitModelObject && adapterType == ResourceMapping.class) {
            return adapterType.cast(GitObjectMapping.create((GitModelObject)((Object)adaptableObject)));
        }
        if (adaptableObject instanceof GitModelObject && adapterType == IResource.class) {
            IFile res;
            GitModelObject obj = (GitModelObject)((Object)adaptableObject);
            if (obj instanceof GitModelBlob) {
                res = ResourceUtil.getFileForLocation((IPath)obj.getLocation(), (boolean)false);
                if (res == null) {
                    res = this.getWorkspaceResourceFromGitPath(obj.getLocation());
                }
                return adapterType.cast(res);
            }
            if (obj instanceof GitModelTree) {
                res = root.getContainerForLocation(obj.getLocation());
                if (res == null) {
                    res = root.getFolder(obj.getLocation());
                }
                return adapterType.cast(res);
            }
        }
        if (adapterType == Repository.class && (m = (ResourceMapping)Adapters.adapt((Object)adaptableObject, ResourceMapping.class)) != null) {
            return adapterType.cast(SelectionUtils.getRepository((IStructuredSelection)new StructuredSelection((Object)m)));
        }
        return null;
    }

    @Nullable
    private IResource getWorkspaceResourceFromGitPath(IPath gitPath) {
        Repository repository = Activator.getDefault().getRepositoryCache().getRepository(gitPath);
        if (repository == null || repository.isBare()) {
            return null;
        }
        IPath repoRelativePath = gitPath.makeRelativeTo((IPath)new Path(repository.getWorkTree().getAbsolutePath()));
        IProject[] projects = ProjectUtil.getProjectsContaining((Repository)repository, Collections.singleton(repoRelativePath.toString()));
        if (projects.length > 0) {
            IPath projectRelativePath = gitPath.makeRelativeTo(projects[0].getLocation());
            if (projectRelativePath.isEmpty()) {
                return projects[0];
            }
            return projects[0].getFile(projectRelativePath);
        }
        return root.getFile(gitPath);
    }

    @Nullable
    private static Repository getRepository(IURIEditorInput uriInput) {
        File file = GitAdapterFactory.getFile(uriInput);
        if (file == null) {
            return null;
        }
        Path path = new Path(file.getAbsolutePath());
        RepositoryMapping mapping = RepositoryMapping.getMapping((IPath)path);
        if (mapping != null) {
            return mapping.getRepository();
        }
        Repository repository = Activator.getDefault().getRepositoryCache().getRepository((IPath)path);
        return repository;
    }

    @Nullable
    private static File getFile(IURIEditorInput uriInput) {
        URI uri = uriInput.getURI();
        if (uri == null) {
            return null;
        }
        try {
            IFileStore store = EFS.getStore((URI)uri);
            if (store != null) {
                return store.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IHistoryPageSource.class, ISynchronizationCompareAdapter.class, ResourceMapping.class, IResource.class, IWorkbenchAdapter.class, IShowInSource.class, Repository.class, File.class, IHistoryPageSource.class};
    }
}

