/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog.command;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.reflog.ReflogView;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class AbstractReflogCommandHandler
extends AbstractHandler {
    AbstractReflogCommandHandler() {
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected Repository getRepository(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        if (!(part instanceof ReflogView)) {
            throw new ExecutionException(UIText.AbstractReflogCommandHandler_NoInput);
        }
        return ((ReflogView)part).getRepository();
    }

    protected ReflogView getView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (window.getActivePage() == null) {
            return null;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        if (!(part instanceof ReflogView)) {
            return null;
        }
        return (ReflogView)part;
    }

    protected RevCommit getSelectedCommit(ExecutionEvent event, Repository repo) throws ExecutionException {
        ReflogEntry entry = (ReflogEntry)((IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event)).getFirstElement();
        if (entry == null) {
            return null;
        }
        RevCommit commit = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (RevWalk w = new RevWalk(repo);){
                commit = w.parseCommit((AnyObjectId)entry.getNewId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return commit;
    }
}

