/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public final class JDTRefactoringDescriptorComment {
    private static final String ELEMENT_DELIMITER = RefactoringCoreMessages.JavaRefactoringDescriptorComment_element_delimiter;
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    private final String fHeader;
    private final String fProject;
    private final List<String> fSettings = new ArrayList<String>(6);

    public static String createCompositeSetting(String caption, String[] settings) {
        Assert.isNotNull((Object)caption);
        Assert.isNotNull((Object)settings);
        StringBuilder buffer = new StringBuilder(128);
        int index = 0;
        while (index < settings.length) {
            if (settings[index] != null && !"".equals(settings[index])) {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(settings[index]);
            } else {
                buffer.append(LINE_DELIMITER);
                buffer.append(ELEMENT_DELIMITER);
                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
            }
            ++index;
        }
        if (buffer.length() > 0) {
            buffer.insert(0, caption);
        }
        return buffer.toString();
    }

    public JDTRefactoringDescriptorComment(String project, Object object, String header) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)header);
        this.fProject = project;
        this.fHeader = header;
        this.initializeInferredSettings(object);
    }

    public void addSetting(int index, String setting) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)setting);
        Assert.isTrue((!"".equals(setting) ? 1 : 0) != 0);
        this.fSettings.add(index, setting);
    }

    public void addSetting(String setting) {
        if (setting != null && !"".equals(setting)) {
            this.fSettings.add(setting);
        }
    }

    public String asString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.fHeader);
        if (this.fProject != null && !"".equals(this.fProject)) {
            buffer.append(LINE_DELIMITER);
            buffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_original_project, BasicElementLabels.getResourceName(this.fProject)));
        }
        for (String setting : this.fSettings) {
            buffer.append(LINE_DELIMITER);
            buffer.append(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_inferred_setting_pattern, setting));
        }
        return buffer.toString();
    }

    public int getCount() {
        return this.fSettings.size();
    }

    private void initializeInferredSettings(Object object) {
        Object updating;
        block40: {
            if (object instanceof INameUpdating) {
                updating = (INameUpdating)object;
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabelsCore.getTextLabel(updating.getElements()[0], JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                try {
                    Object element = updating.getNewElement();
                    if (element != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, JavaElementLabelsCore.getTextLabel(element, JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                        break block40;
                    }
                    String newLabel = BasicElementLabels.getJavaElementName(updating.getCurrentElementName());
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_renamed_element_pattern, newLabel));
                }
                catch (CoreException exception) {
                    JavaManipulationPlugin.log(exception);
                }
            } else if (object instanceof RefactoringProcessor) {
                RefactoringProcessor processor = (RefactoringProcessor)object;
                Object[] elements = processor.getElements();
                if (elements != null) {
                    if (elements.length == 1 && elements[0] != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabelsCore.getTextLabel(elements[0], JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                    } else if (elements.length > 1) {
                        StringBuilder buffer = new StringBuilder(128);
                        buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] != null) {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(JavaElementLabelsCore.getTextLabel(elements[index], JavaElementLabelsCore.ALL_FULLY_QUALIFIED));
                            } else {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                            }
                            ++index;
                        }
                        this.fSettings.add(buffer.toString());
                    }
                }
            } else if (object instanceof IReorgPolicy) {
                IReorgPolicy.IMovePolicy extended;
                IReorgPolicy policy = (IReorgPolicy)object;
                IJavaElement destination = policy.getJavaElementDestination();
                if (destination != null) {
                    this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabelsCore.getTextLabel(destination, JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                } else {
                    destination = policy.getResourceDestination();
                    if (destination != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptorComment_destination_pattern, JavaElementLabelsCore.getTextLabel(destination, JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                    }
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll(Arrays.asList(policy.getJavaElements()));
                list.addAll(Arrays.asList(policy.getResources()));
                Object[] elements = list.toArray();
                if (elements != null) {
                    if (elements.length == 1 && elements[0] != null) {
                        this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_original_element_pattern, JavaElementLabelsCore.getTextLabel(elements[0], JavaElementLabelsCore.ALL_FULLY_QUALIFIED)));
                    } else if (elements.length > 1) {
                        StringBuilder buffer = new StringBuilder(128);
                        buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_original_elements);
                        int index = 0;
                        while (index < elements.length) {
                            if (elements[index] != null) {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(JavaElementLabelsCore.getTextLabel(elements[index], JavaElementLabelsCore.ALL_FULLY_QUALIFIED));
                            } else {
                                buffer.append(LINE_DELIMITER);
                                buffer.append(ELEMENT_DELIMITER);
                                buffer.append(RefactoringCoreMessages.JavaRefactoringDescriptor_not_available);
                            }
                            ++index;
                        }
                        this.fSettings.add(buffer.toString());
                    }
                }
                if (object instanceof IReorgPolicy.IMovePolicy && (extended = (IReorgPolicy.IMovePolicy)object).isTextualMove()) {
                    this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptorComment_textual_move_only);
                }
            }
        }
        if (object instanceof IReferenceUpdating && (updating = (IReferenceUpdating)object).getUpdateReferences()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        if (object instanceof ISimilarDeclarationUpdating && (updating = (ISimilarDeclarationUpdating)object).canEnableSimilarDeclarationUpdating() && updating.getUpdateSimilarDeclarations()) {
            int strategy = updating.getMatchStrategy();
            switch (strategy) {
                case 1: {
                    this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar);
                    break;
                }
                case 2: {
                    this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_embedded);
                    break;
                }
                case 3: {
                    this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_rename_similar_suffix);
                    break;
                }
            }
        }
        if (object instanceof IQualifiedNameUpdating && (updating = (IQualifiedNameUpdating)object).canEnableQualifiedNameUpdating() && updating.getUpdateQualifiedNames()) {
            String patterns = updating.getFilePatterns();
            if (patterns != null && !"".equals(patterns)) {
                this.fSettings.add(Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names_pattern, BasicElementLabels.getFilePattern(patterns.trim())));
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_qualified_names);
            }
        }
        if (object instanceof ITextUpdating && (updating = (ITextUpdating)object).canEnableTextUpdating()) {
            this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_textual_occurrences);
        }
        if (object instanceof IDelegateUpdating && (updating = (IDelegateUpdating)object).canEnableDelegateUpdating() && updating.getDelegateUpdating()) {
            if (updating.getDeprecateDelegates()) {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original_deprecated);
            } else {
                this.fSettings.add(RefactoringCoreMessages.JavaRefactoringDescriptor_keep_original);
            }
        }
    }

    public void removeSetting(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        this.fSettings.remove(index);
    }
}

