/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.IVerificationProcessor;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class VerificationsRuntime {
    private static VerificationsRuntime instance;
    private final HashMap<String, Object> data = new HashMap();

    public static VerificationsRuntime getInstance() {
        if (instance == null) {
            instance = new VerificationsRuntime();
        }
        return instance;
    }

    public void resetVerifications() {
        this.data.clear();
    }

    public void executeStart(Verification verification, IProcess process) throws CoreException {
        IVerificationProcessor processor = VerificationsRuntime.getProcessor(verification);
        this.data.put(verification.getId(), processor.start(verification, process));
    }

    public void executeRun(Verification verification, IProcess process) throws CoreException {
        IVerificationProcessor processor = VerificationsRuntime.getProcessor(verification);
        this.data.put(verification.getId(), processor.run(verification, this.data.get(verification.getId()), process));
    }

    public void executeFinish(Verification verification, IProcess process) throws CoreException {
        IVerificationProcessor processor = VerificationsRuntime.getProcessor(verification);
        processor.finish(verification, this.data.get(verification.getId()), process);
    }

    private static IVerificationProcessor getProcessor(Verification verification) throws CoreException {
        VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification(verification);
        if (type == null) {
            throw new CoreException(RcpttPlugin.createStatus("Failed to locate type for verification:" + verification.getId()));
        }
        IVerificationProcessor processor = VerificationTypeManager.getInstance().getProcessor(type.getId());
        if (processor == null) {
            throw new CoreException(RcpttPlugin.createStatus("Failed to locate processor for verification:" + verification.getId()));
        }
        return processor;
    }
}

