/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt.rap;

import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.SWTWidgetLocator;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.swt.widgets.Widget;

public class RecordingWidgetDescriber
extends WidgetDescriber
implements IRecordingDescriber {
    private SWTUIElement uiElement;
    protected boolean needLogging;

    public RecordingWidgetDescriber(Widget widget) {
        super(widget);
    }

    public RecordingWidgetDescriber(SWTUIElement element) {
        super(element.unwrap());
        this.uiElement = element;
    }

    @Override
    public Element searchForElement(TeslaRecorder recorder) {
        SWTWidgetLocator processor = SWTRecordingHelper.getHelper().getLocator();
        FindResult result = null;
        if (this.uiElement != null) {
            if (this.needLogging && TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"assert engine", (String)("looking identity for element: " + this.uiElement.getClassName()));
            }
            result = processor.findElement(this.uiElement, false, false, true);
        } else {
            if (this.needLogging && TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"assert engine", (String)("assert properties of element: " + this.getWidget().getClass().getName()));
            }
            result = processor.findElement(this.getWidget(), true, false, true);
        }
        if (result != null) {
            return result.element;
        }
        return null;
    }

    @Override
    public IRecordingDescriber getParent() {
        SWTWidgetLocator processor = SWTRecordingHelper.getHelper().getLocator();
        SWTUIPlayer pl = processor.getPlayer();
        SWTUIElement element = pl.getParentElement(pl.wrap((Object)this.getWidget()));
        if (element == null) {
            return this;
        }
        return new RecordingWidgetDescriber(element);
    }

    @Override
    public void setNeedLogging(boolean need) {
        this.needLogging = need;
    }
}

