/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;

public class Q7Launcher {
    private static Q7Launcher instance = new Q7Launcher();
    public static final int DEFAULT_LAUNCH_TIMEOUT = 300;
    private Map<ILaunchConfiguration, LaunchData> launchData = new HashMap<ILaunchConfiguration, LaunchData>();

    public static Q7Launcher getInstance() {
        if (instance == null) {
            instance = new Q7Launcher();
        }
        return instance;
    }

    private Q7Launcher() {
    }

    public void addListener(ILaunchListener listener) {
        this.getManager().addListener(listener);
    }

    public void removeListener(ILaunchListener listener) {
        this.getManager().removeListener(listener);
    }

    public boolean isRunned() {
        return this.getManager().isRunning();
    }

    public void stop() {
        this.getManager().stop();
    }

    public IExecutionSession execute(IQ7NamedElement[] elements, Aut aut, String name) throws CoreException {
        return this.execute(elements, aut, name, null);
    }

    public IExecutionSession execute(IQ7NamedElement[] elements, Aut aut, String name, IWorkspaceFinder finder) throws CoreException {
        try {
            ILaunchConfiguration config = Q7Launcher.getLaunchConfiguration(elements, aut);
            LaunchData data = new LaunchData();
            data.elements = elements;
            data.finder = finder;
            this.launchData.put(config, data);
            Q7TestLaunch launch = (Q7TestLaunch)config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.launchData.remove(config);
            return launch.getClearSession();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Failed to execute ECL. Connection could not be established..." + e.getMessage(), (Throwable)e));
        }
    }

    public int getMaxHistoryEntries() {
        return this.getManager().getMaxHistoryEntries();
    }

    public IExecutionSession[] getExecutionSessions() {
        return this.getManager().getExecutionSessions();
    }

    public boolean removeExecutionSession(IExecutionSession session) {
        return this.getManager().removeExecutionSession(session);
    }

    public void setMaxHistoryEntries(int maxEntries) {
        this.getManager().setMaxHistoryEntries(maxEntries);
    }

    public static ILaunchConfiguration getLaunchConfiguration(IQ7NamedElement[] elements, Aut aut) throws CoreException {
        return Q7Launcher.getLaunchConfiguration(elements, aut, null, true, null);
    }

    private static void setMappedResources(ILaunchConfigurationWorkingCopy temporary, IQ7NamedElement[] elements) throws CoreException {
        if (elements.length > 0 && elements[0].getQ7Project() != null) {
            List<IResource> resources = Q7Launcher.elementsToResources(elements);
            List<IResource> extras = Q7Launcher.elementsToResources(Q7Launcher.collectReferences(elements, null));
            int resourcesToExec = resources.size();
            resources.addAll(extras);
            temporary.setAttribute("q7.exec.resources", resourcesToExec);
            temporary.setMappedResources(resources.toArray(new IResource[resources.size()]));
        }
    }

    public static void setMappedResources(ILaunchConfiguration config, IQ7NamedElement[] elements) throws CoreException {
        ILaunchConfigurationWorkingCopy temporary = config.getWorkingCopy();
        Q7Launcher.setMappedResources(temporary, elements);
        temporary.doSave();
    }

    public static ILaunchConfiguration getLaunchConfiguration(IQ7NamedElement[] elements, Aut aut, String name, boolean sort, Map<String, List<List<String>>> variants) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType("org.eclipse.rcptt.launching.scenarios");
        if (name == null) {
            name = Q7Launcher.getLaunchName(elements);
        }
        boolean includeContexts = !Q7Launcher.hasScenarios(elements);
        ILaunchConfigurationWorkingCopy temporary = configType.newInstance(null, manager.generateLaunchConfigurationName(name));
        temporary.setAttribute("org.eclipse.rcptt.launching.INCLUDE_CONTEXT_ATTR", includeContexts);
        if (aut != null) {
            temporary.setAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", aut.getName());
        }
        temporary.setAttribute("org.eclipse.rcptt.launching.NO_SORT", !sort);
        if (variants != null && variants.size() > 0) {
            HashMap<String, String> strVariants = new HashMap<String, String>();
            for (Map.Entry<String, List<List<String>>> e : variants.entrySet()) {
                StringBuilder sb = new StringBuilder();
                List<List<String>> variantNames = e.getValue();
                int i = 0;
                while (i < variantNames.size()) {
                    sb.append(Joiner.on((String)"%$%${q7.variantname}").join((Iterable)variantNames.get(i)));
                    if (i < variantNames.size() - 1) {
                        sb.append("%$%${q7.variants}");
                    }
                    ++i;
                }
                strVariants.put(e.getKey(), sb.toString());
            }
            temporary.setAttribute("q7.context.variants", strVariants);
        }
        Q7Launcher.setMappedResources(temporary, elements);
        ILaunchConfiguration config = Q7Launcher.findExistingLaunchConfiguration(manager, temporary);
        if (config == null) {
            config = temporary.doSave();
        }
        return config;
    }

    private static IQ7NamedElement[] findReferences(IQ7NamedElement element, IWorkspaceFinder finder) throws ModelException {
        IContext[] elements;
        if (element instanceof ITestSuite) {
            return Q7SearchCore.getTestSuiteContent((ITestSuite)((ITestSuite)element));
        }
        if (element instanceof ITestCase) {
            return RcpttCore.getInstance().getContexts((ITestCase)element, finder, true);
        }
        if (element instanceof IContext && (elements = RcpttCore.getInstance().getContexts((IContext)element, finder, true)) == null) {
            return new IQ7NamedElement[0];
        }
        return new IQ7NamedElement[0];
    }

    private static IQ7NamedElement[] collectReferences(IQ7NamedElement[] elements, IWorkspaceFinder finder) throws ModelException {
        HashSet<IQ7NamedElement> result = new HashSet<IQ7NamedElement>();
        Q7Launcher.collectReferences(elements, result, new HashSet<IQ7NamedElement>(), finder);
        return result.toArray(new IQ7NamedElement[result.size()]);
    }

    private static List<IResource> elementsToResources(IQ7NamedElement[] elements) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            if (element != null) {
                IResource resource = element.getResource();
                result.add(resource);
            }
            ++n2;
        }
        return result;
    }

    private static boolean hasScenarios(IQ7NamedElement[] elements) {
        return Q7Launcher.excludeNonScenarios(elements).length > 0;
    }

    private static IQ7NamedElement[] excludeNonScenarios(IQ7NamedElement[] elements) {
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            if (!(element instanceof IContext) && !(element instanceof IVerification)) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IQ7NamedElement[result.size()]);
    }

    private static void collectReferences(IQ7NamedElement[] elements, Set<IQ7NamedElement> result, Set<IQ7NamedElement> traversed, IWorkspaceFinder finder) throws ModelException {
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            if (!traversed.contains(element)) {
                traversed.add(element);
                IQ7NamedElement[] references = Q7Launcher.findReferences(element, finder);
                result.addAll(Arrays.asList(references));
                Q7Launcher.collectReferences(references, result, traversed, finder);
            }
            ++n2;
        }
    }

    public static String getLaunchName(IQ7NamedElement[] elements) {
        if (elements.length == 0) {
            return "Empty Test Suite";
        }
        if (elements.length == 1) {
            try {
                return elements[0].getElementName();
            }
            catch (ModelException modelException) {
                return elements[0].getName();
            }
        }
        IPath commonPath = Q7Launcher.getCommonPath(elements);
        if (commonPath.segmentCount() > 0) {
            return commonPath.lastSegment();
        }
        return "Test Suite";
    }

    public static int getLaunchTimeout() {
        IEclipsePreferences preferences = Q7LaunchingPlugin.getPreferences();
        return preferences.getInt("EXECUTION_TIMEOUT", 300);
    }

    public static void setLaunchTimeout(int timeout) {
        IEclipsePreferences preferences = Q7LaunchingPlugin.getPreferences();
        preferences.putInt("EXECUTION_TIMEOUT", timeout);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log(e);
        }
    }

    private static IPath getCommonPath(IQ7NamedElement[] elements) {
        IPath commonPath = elements[0].getPath().removeLastSegments(1);
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            IPath currentPath = element.getPath().removeLastSegments(1);
            int i = 0;
            while (i < commonPath.segmentCount()) {
                if (!(i <= currentPath.segmentCount() && commonPath.segment(i).equals(currentPath.segment(i)) || (commonPath = commonPath.removeLastSegments(commonPath.segmentCount() - i)).segmentCount() != 0)) {
                    return commonPath;
                }
                ++i;
            }
            ++n2;
        }
        return commonPath;
    }

    private static ILaunchConfiguration findExistingLaunchConfiguration(ILaunchManager manager, ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        List<ILaunchConfiguration> candidateConfigs = Q7Launcher.findExistingLaunchConfigurations(manager, temporary);
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        ILaunchConfiguration result = candidateConfigs.get(0);
        ILaunchConfigurationWorkingCopy copy = result.getWorkingCopy();
        copy.setAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", temporary.getAttribute("org.eclipse.rcptt.launching.AUT_NAME_ATTR", ""));
        copy.setAttribute("q7.context.variants", temporary.getAttribute("q7.context.variants", new HashMap()));
        copy.doSave();
        return result;
    }

    private static List<ILaunchConfiguration> findExistingLaunchConfigurations(ILaunchManager manager, ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (Q7Launcher.hasSameAttributes(config, (ILaunchConfiguration)temporary)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        return candidateConfigs;
    }

    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2) {
        block3: {
            try {
                boolean c1_includeContext = config1.getAttribute("org.eclipse.rcptt.launching.INCLUDE_CONTEXT_ATTR", false);
                boolean c2_includeContext = config2.getAttribute("org.eclipse.rcptt.launching.INCLUDE_CONTEXT_ATTR", false);
                if (c1_includeContext == c2_includeContext) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return Arrays.equals(TestSuiteUtils.getElements(config1, true), TestSuiteUtils.getElements(config2, true));
    }

    private Q7LaunchManager getManager() {
        return Q7LaunchManager.getInstance();
    }

    public LaunchData getRemoveLaunchData(ILaunchConfiguration config) {
        LaunchData data = this.launchData.get(config);
        this.launchData.remove(config);
        return data;
    }

    public static class LaunchData {
        public IQ7NamedElement[] elements;
        public IWorkspaceFinder finder;
    }
}

