/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTInstructionCompiler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class JavaPrimitiveValueEditor
implements IVariableValueEditor {
    private String fSignature = null;

    public JavaPrimitiveValueEditor(String signature) {
        this.fSignature = signature;
    }

    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            String name = variable.getName();
            String title = ActionMessages.JavaPrimitiveValueEditor_0;
            String message = MessageFormat.format((String)ActionMessages.JavaPrimitiveValueEditor_1, (Object[])new String[]{name});
            String initialValue = variable.getValue().getValueString();
            PrimitiveValidator validator = new PrimitiveValidator();
            InputDialog dialog = new InputDialog(shell, title, message, initialValue, validator){

                protected Control createDialogArea(Composite parent) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.DEFAULT_INPUT_DIALOG);
                    return super.createDialogArea(parent);
                }
            };
            if (dialog.open() == 0) {
                int i;
                String stringValue = dialog.getValue();
                if ((stringValue = this.formatValue(stringValue)).length() > 1 && stringValue.charAt(0) == '\\' && (i = validator.getEscapeValue(stringValue)) != Integer.MAX_VALUE) {
                    stringValue = new String(new char[]{(char)i});
                }
                variable.setValue(stringValue);
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.errorDialog(shell, ActionMessages.JavaPrimitiveValueEditor_2, ActionMessages.JavaPrimitiveValueEditor_3, e);
        }
        return true;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        return false;
    }

    String formatValue(String value) {
        try {
            switch (this.fSignature.charAt(0)) {
                case 'I': {
                    return Integer.toString(ASTInstructionCompiler.parseIntValue((String)value));
                }
                case 'J': {
                    return Long.toString(ASTInstructionCompiler.parseLongValue((String)value));
                }
                case 'S': {
                    return Short.toString(ASTInstructionCompiler.parseShortValue((String)value));
                }
                case 'D': 
                case 'F': {
                    return ASTInstructionCompiler.removePrefixZerosAndUnderscores((String)value, (boolean)false);
                }
                case 'B': {
                    return Byte.toString(ASTInstructionCompiler.parseByteValue((String)value));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    protected class PrimitiveValidator
    implements IInputValidator {
        protected PrimitiveValidator() {
        }

        public String isValid(String newText) {
            String type = null;
            switch (JavaPrimitiveValueEditor.this.fSignature.charAt(0)) {
                case 'B': {
                    try {
                        Byte.parseByte(newText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "byte";
                    }
                    break;
                }
                case 'C': {
                    if (newText.length() > 1 && newText.charAt(0) == '\\' && (this.isSpecialCharacter(newText) || this.isOctalEscape(newText) || this.isUnicode(newText)) || newText.length() == 1) break;
                    type = "char";
                    break;
                }
                case 'D': {
                    try {
                        Double.parseDouble(ASTInstructionCompiler.removePrefixZerosAndUnderscores((String)newText, (boolean)false));
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "double";
                    }
                    break;
                }
                case 'F': {
                    try {
                        Float.parseFloat(ASTInstructionCompiler.removePrefixZerosAndUnderscores((String)newText, (boolean)false));
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "float";
                    }
                    break;
                }
                case 'I': {
                    try {
                        ASTInstructionCompiler.parseIntValue((String)newText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "int";
                    }
                    break;
                }
                case 'J': {
                    try {
                        ASTInstructionCompiler.parseLongValue((String)newText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "long";
                    }
                    break;
                }
                case 'S': {
                    try {
                        ASTInstructionCompiler.parseShortValue((String)newText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        type = "short";
                    }
                    break;
                }
                case 'Z': {
                    if ("true".equals(newText) || "false".equals(newText)) break;
                    type = "boolean";
                }
            }
            if (type != null) {
                return MessageFormat.format((String)ActionMessages.JavaPrimitiveValueEditor_4, (Object[])new String[]{type});
            }
            return null;
        }

        private boolean isUnicode(String newText) {
            if (newText.length() == 6 && newText.charAt(1) == 'u') {
                char[] chars = newText.toCharArray();
                int i = 2;
                while (i < chars.length) {
                    if (!this.isHexDigit(chars[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        private boolean isOctalEscape(String newText) {
            char[] chars = newText.toCharArray();
            if (chars.length < 4) {
                int i = 1;
                while (i < chars.length) {
                    if (!this.isOctalDigit(chars[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (chars.length == 4) {
                char ch = chars[1];
                if (ch < '0' || ch > '3') {
                    return false;
                }
                int i = 2;
                while (i < chars.length) {
                    if (!this.isOctalDigit(chars[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        private boolean isSpecialCharacter(String newText) {
            char ch = newText.charAt(1);
            return newText.length() == 2 && (ch == 'b' || ch == 't' || ch == 'n' || ch == 'f' || ch == 'r' || ch == '\"' || ch == '\'' || ch == '\\');
        }

        private boolean isOctalDigit(char ch) {
            return Character.digit(ch, 8) != -1;
        }

        private boolean isHexDigit(char ch) {
            return Character.digit(ch, 16) != -1;
        }

        protected int getEscapeValue(String string) {
            return ASTInstructionCompiler.parseIntValue((String)string);
        }
    }
}

