/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardJavaBreakpointEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WatchpointEditor
extends StandardJavaBreakpointEditor {
    public static final int PROP_ACCESS = 4112;
    public static final int PROP_MODIFICATION = 4113;
    private Button fAccess;
    private Button fModification;

    public Control createControl(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)0, (int)0, (int)0);
        super.createStandardControls(container);
        Composite watchComp = SWTFactory.createComposite((Composite)container, (Font)parent.getFont(), (int)2, (int)1, (int)0, (int)0, (int)0);
        this.fAccess = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(PropertyPageMessages.JavaLineBreakpointPage_7), 4112);
        this.fModification = this.createSusupendPropertyEditor(watchComp, this.processMnemonics(PropertyPageMessages.JavaLineBreakpointPage_8), 4113);
        return container;
    }

    protected void setBreakpoint(IJavaBreakpoint breakpoint) throws CoreException {
        super.setBreakpoint(breakpoint);
        if (breakpoint instanceof IJavaWatchpoint) {
            IJavaWatchpoint watchpoint = (IJavaWatchpoint)breakpoint;
            this.fAccess.setEnabled(true);
            this.fModification.setEnabled(true);
            this.fAccess.setSelection(watchpoint.isAccess());
            this.fModification.setSelection(watchpoint.isModification());
        } else {
            this.fAccess.setEnabled(false);
            this.fModification.setEnabled(false);
            this.fAccess.setSelection(false);
            this.fModification.setSelection(false);
        }
    }

    public void doSave() throws CoreException {
        super.doSave();
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IJavaWatchpoint) {
            IJavaWatchpoint watchpoint = (IJavaWatchpoint)breakpoint;
            watchpoint.setAccess(this.fAccess.getSelection());
            watchpoint.setModification(this.fModification.getSelection());
        }
    }
}

