/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.raw;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TeslaMode implements Enumerator
{
    FEATURES(0, "Features", "Features"),
    RECORDING(1, "Recording", "Recording"),
    REPLAY(2, "Replay", "Replay"),
    ASSERTIONS(3, "Assertions", "Assertions"),
    PAUSE(4, "Pause", "Pause");

    public static final int FEATURES_VALUE = 0;
    public static final int RECORDING_VALUE = 1;
    public static final int REPLAY_VALUE = 2;
    public static final int ASSERTIONS_VALUE = 3;
    public static final int PAUSE_VALUE = 4;
    private static final TeslaMode[] VALUES_ARRAY;
    public static final List<TeslaMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TeslaMode[]{FEATURES, RECORDING, REPLAY, ASSERTIONS, PAUSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TeslaMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TeslaMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TeslaMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TeslaMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TeslaMode get(int value) {
        switch (value) {
            case 0: {
                return FEATURES;
            }
            case 1: {
                return RECORDING;
            }
            case 2: {
                return REPLAY;
            }
            case 3: {
                return ASSERTIONS;
            }
            case 4: {
                return PAUSE;
            }
        }
        return null;
    }

    private TeslaMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

