/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerTypeFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;

public class TypesConfigurationArea
extends GroupFilterConfigurationArea {
    private static Collection EMPTY_COLLECTION = new HashSet();
    private HashMap models = new HashMap(0);
    private CheckboxTreeViewer typesViewer;

    public void apply(MarkerFieldFilter filter) {
        ArrayList<MarkerType> selectedTypes = new ArrayList<MarkerType>();
        Object[] elements = this.typesViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof MarkerTypeEntry) {
                selectedTypes.add(((MarkerTypeEntry)elements[i]).getMarkerType());
            }
            ++i;
        }
        MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)this.typesViewer.getInput();
        ((MarkerTypeFieldFilter)filter).setSelectedTypes(selectedTypes, group.generator);
    }

    public void applyToGroup(MarkerFieldFilterGroup group) {
    }

    public void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Tree tree = new Tree(composite, 68386);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(false);
        this.typesViewer = new CheckboxTreeViewer(tree);
        this.initializeFontMetrics((Control)tree);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)100);
        gridData.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)50);
        final ITreeContentProvider typesContentProvider = this.getTypesContentProvider();
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)typesContentProvider);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TypesEntry)element).getLabel();
            }
        });
        this.typesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((TypesEntry)e1).getLabel().compareTo(((TypesEntry)e2).getLabel());
            }
        });
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean checked = event.getChecked();
                TypesConfigurationArea.this.typesViewer.setGrayed(element, false);
                this.setChildrenChecked(element, checked);
                this.setParentCheckState(element, checked);
            }

            private void setChildrenChecked(Object element, boolean checked) {
                Object[] children = typesContentProvider.getChildren(element);
                if (children.length > 0) {
                    int i = 0;
                    while (i < children.length) {
                        TypesConfigurationArea.this.typesViewer.setChecked(children[i], checked);
                        ++i;
                    }
                }
            }

            private void setParentCheckState(Object element, boolean checked) {
                Object parent = typesContentProvider.getParent(element);
                if (parent == null) {
                    return;
                }
                Object[] children = typesContentProvider.getChildren(parent);
                int i = 0;
                while (i < children.length) {
                    if (TypesConfigurationArea.this.typesViewer.getChecked(children[i]) != checked) {
                        TypesConfigurationArea.this.typesViewer.setGrayChecked(parent, true);
                        return;
                    }
                    ++i;
                }
                TypesConfigurationArea.this.typesViewer.setGrayed(parent, false);
                TypesConfigurationArea.this.typesViewer.setChecked(parent, checked);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)buttonsData);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(MarkerMessages.filtersDialog_selectAllTypes);
        selectAllButton.addSelectionListener(this.getSelectAllButtonListener(typesContentProvider, true));
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(MarkerMessages.filtersDialog_deselectAllTypes);
        deselectAllButton.addSelectionListener(this.getSelectAllButtonListener(typesContentProvider, false));
        this.setButtonLayoutData(deselectAllButton);
    }

    public boolean grabExcessVerticalSpace() {
        return true;
    }

    private SelectionListener getSelectAllButtonListener(final ITreeContentProvider typesContentProvider, final boolean checked) {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] elements = typesContentProvider.getElements(TypesConfigurationArea.this.typesViewer.getInput());
                int i = 0;
                while (i < elements.length) {
                    TypesConfigurationArea.this.typesViewer.setSubtreeChecked(elements[i], checked);
                    ++i;
                }
            }
        };
    }

    protected List elementsForGroup(MarkerFieldFilterGroup group) {
        if (this.models.containsKey(group)) {
            return (List)this.models.get(group);
        }
        Iterator roots = group.getAllTypes().iterator();
        ArrayList<TypesEntry> markerNodes = new ArrayList<TypesEntry>();
        HashMap<String, CategoryEntry> categories = new HashMap<String, CategoryEntry>();
        while (roots.hasNext()) {
            CategoryEntry category;
            MarkerType markerType = (MarkerType)roots.next();
            String categoryName = MarkerSupportRegistry.getInstance().getCategory(markerType.getId());
            if (categoryName == null) {
                markerNodes.add(new MarkerTypeEntry(markerType));
                continue;
            }
            if (categories.containsKey(categoryName)) {
                category = (CategoryEntry)categories.get(categoryName);
            } else {
                category = new CategoryEntry(categoryName);
                categories.put(categoryName, category);
                markerNodes.add(category);
            }
            MarkerTypeEntry node = new MarkerTypeEntry(markerType);
            category.add(node);
        }
        this.models.put(group, markerNodes);
        return markerNodes;
    }

    private void findTypeEntries(MarkerFieldFilterGroup group, Collection entries, Collection greyEntries) {
        Iterator elements = this.elementsForGroup(group).iterator();
        Collection selectedTypes = ((MarkerTypeFieldFilter)group.getFilter(this.getField())).getSelectedTypes();
        block0: while (elements.hasNext()) {
            TypesEntry entry = (TypesEntry)elements.next();
            entry.addElementsMatching(selectedTypes, entries);
            if (!entry.hasChildren()) continue;
            Collection children = entry.getChildren();
            if (entries.containsAll(children)) {
                entries.add(entry);
                continue;
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                if (!entries.contains(iterator.next())) continue;
                greyEntries.add(entry);
                continue block0;
            }
        }
    }

    private ITreeContentProvider getTypesContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return ((TypesEntry)parentElement).getChildren().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return TypesConfigurationArea.this.elementsForGroup((MarkerFieldFilterGroup)inputElement).toArray();
            }

            public Object getParent(Object element) {
                return ((TypesEntry)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((TypesEntry)element).hasChildren();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void initialize(MarkerFieldFilter filter) {
    }

    public void initializeFromGroup(MarkerFieldFilterGroup group) {
        this.typesViewer.setInput((Object)group);
        this.typesViewer.refresh();
        HashSet checked = new HashSet();
        HashSet greyed = new HashSet();
        this.findTypeEntries(group, checked, greyed);
        checked.addAll(greyed);
        this.typesViewer.setCheckedElements(checked.toArray());
        this.typesViewer.setGrayedElements(greyed.toArray());
    }

    public String getTitle() {
        return MarkerMessages.filtersDialog_typesTitle;
    }

    private class CategoryEntry
    extends TypesEntry {
        private Collection children = new ArrayList();
        private String name;

        public CategoryEntry(String categoryName) {
            this.name = categoryName;
        }

        public void add(MarkerTypeEntry node) {
            this.children.add(node);
            node.setParent(this);
        }

        public void addElementsMatching(Collection selectedTypes, Collection entries) {
            Iterator childIterator = this.children.iterator();
            while (childIterator.hasNext()) {
                ((MarkerTypeEntry)childIterator.next()).addElementsMatching(selectedTypes, entries);
            }
        }

        public Collection getChildren() {
            return this.children;
        }

        public String getLabel() {
            return this.name;
        }

        public TypesEntry getParent() {
            return null;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private class MarkerTypeEntry
    extends TypesEntry {
        private CategoryEntry category;
        private MarkerType markerType;

        public MarkerTypeEntry(MarkerType markerType) {
            this.markerType = markerType;
        }

        public void addElementsMatching(Collection selectedTypes, Collection entries) {
            if (selectedTypes.contains(this.markerType)) {
                entries.add(this);
            }
        }

        public Collection getChildren() {
            return EMPTY_COLLECTION;
        }

        public String getLabel() {
            return this.markerType.getLabel();
        }

        public MarkerType getMarkerType() {
            return this.markerType;
        }

        public TypesEntry getParent() {
            return this.category;
        }

        public boolean hasChildren() {
            return false;
        }

        public void setParent(CategoryEntry categoryEntry) {
            this.category = categoryEntry;
        }
    }

    private abstract class TypesEntry {
        private TypesEntry() {
        }

        public abstract void addElementsMatching(Collection var1, Collection var2);

        public abstract Collection getChildren();

        public abstract String getLabel();

        public abstract TypesEntry getParent();

        public abstract boolean hasChildren();
    }
}

