/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Section;

public class HookUtils {
    public static void textHook(Composite composite, final Runnable r) {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                r.run();
            }

            public void focusLost(FocusEvent e) {
                r.run();
            }
        };
        HookUtils.textHook(composite, r, focusListener);
    }

    public static void textHook(Composite composite, final Runnable r, FocusListener focusListener) {
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                r.run();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                r.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                r.run();
            }
        };
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                r.run();
            }
        };
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            HookUtils.hookControl(r, focusListener, keyListener, selectionListener, modifyListener, child);
            ++n2;
        }
    }

    private static void hookControl(Runnable r, FocusListener focusListener, KeyAdapter keyListener, SelectionAdapter selectionListener, ModifyListener modifyListener, Control child) {
        if (child instanceof Text) {
            child.addFocusListener(focusListener);
            child.addKeyListener((KeyListener)keyListener);
            ((Text)child).addSelectionListener((SelectionListener)selectionListener);
            ((Text)child).addModifyListener(modifyListener);
        }
        if (child instanceof StyledText) {
            child.addFocusListener(focusListener);
            ((StyledText)child).addModifyListener(modifyListener);
            child.addKeyListener((KeyListener)keyListener);
            ((StyledText)child).addSelectionListener((SelectionListener)selectionListener);
        }
        if (child instanceof Table) {
            Table table = (Table)child;
            table.addFocusListener(focusListener);
            table.addSelectionListener((SelectionListener)selectionListener);
            table.addKeyListener((KeyListener)keyListener);
        } else if (child instanceof Tree) {
            Tree tree = (Tree)child;
            tree.addFocusListener(focusListener);
            tree.addSelectionListener((SelectionListener)selectionListener);
            tree.addKeyListener((KeyListener)keyListener);
        } else if (child instanceof Section) {
            Control textClient;
            Section s = (Section)child;
            Control descr = s.getDescriptionControl();
            if (descr != null) {
                HookUtils.hookControl(r, focusListener, keyListener, selectionListener, modifyListener, descr);
            }
            if ((textClient = s.getTextClient()) != null) {
                HookUtils.hookControl(r, focusListener, keyListener, selectionListener, modifyListener, textClient);
            }
            HookUtils.textHook((Composite)s, r, focusListener);
        } else if (child instanceof ToolBar) {
            ToolItem[] items;
            ToolBar toolbar = (ToolBar)child;
            ToolItem[] toolItemArray = items = toolbar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem toolItem = toolItemArray[n2];
                toolItem.addSelectionListener((SelectionListener)selectionListener);
                ++n2;
            }
        } else if (child instanceof Composite) {
            HookUtils.textHook((Composite)child, r, focusListener);
        }
    }
}

