/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.utils.AdvancedInformationGenerator;
import org.eclipse.rcptt.ui.launching.TimeFormatHelper;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class DetailsDialog
extends Dialog {
    private AdvancedInformation info;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StyledText text;
    private Report report;
    private List<ImageEntry> images = new ArrayList<ImageEntry>();
    private int current = -1;
    private Composite bar;
    private Button nextButton;
    private Button prevButton;
    private Label imageIndex;
    private Label descriptionField;
    private Label imageControl;

    public DetailsDialog(Shell parentShell, AdvancedInformation info, Report report) {
        super(parentShell);
        this.info = info;
        this.report = report;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite sc;
        Composite content = (Composite)super.createDialogArea(parent);
        CTabFolder folder = new CTabFolder(content, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem screenshots = new CTabItem(folder, 0);
        screenshots.setText("Screenshots");
        CTabItem item = new CTabItem(folder, 0);
        this.text = new StyledText((Composite)folder, 2824);
        item.setControl((Control)this.text);
        item.setText("Description");
        Composite ct = new Composite((Composite)folder, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)ct);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(ct);
        this.generateContent();
        if (this.images.size() == 0) {
            screenshots.dispose();
        }
        if (this.images.size() > 0) {
            sc = new ScrolledComposite(ct, 2816);
            GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)sc);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sc);
            this.imageControl = new Label((Composite)sc, 2048);
            this.imageControl.setText(" ");
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.imageControl);
            sc.setContent((Control)this.imageControl);
            screenshots.setControl((Control)ct);
        } else {
            sc = null;
        }
        Label info = new Label(ct, 0);
        info.setText("Details:");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)info);
        this.descriptionField = new Label(ct, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionField);
        if (sc != null) {
            this.bar = null;
            if (this.images.size() > 1) {
                this.bar = new Composite(ct, 0);
                GridDataFactory.fillDefaults().grab(false, false).align(131072, 0x1000000).applyTo((Control)this.bar);
                GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.bar);
                this.imageIndex = new Label(this.bar, 0);
                this.prevButton = new Button(this.bar, 8);
                this.prevButton.setText("Previous");
                this.nextButton = new Button(this.bar, 8);
                this.nextButton.setText("Next");
                this.setButtonLayoutData(this.prevButton);
                this.setButtonLayoutData(this.nextButton);
                this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DetailsDialog.this.updateImage(sc, 1);
                    }
                });
                this.prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DetailsDialog.this.updateImage(sc, -1);
                    }
                });
            }
        }
        if (sc != null) {
            this.updateImage(sc, 1);
        }
        folder.setSelection(0);
        return content;
    }

    private void showImage(Label description, Label imageControl, int selection) {
        if (this.current != selection) {
            if (this.images.size() > selection) {
                ImageEntry imgData = this.images.get(selection);
                description.setText(imgData.description);
                Image img = new Image((Device)imageControl.getDisplay(), (InputStream)new ByteArrayInputStream(imgData.data));
                imageControl.setImage(img);
                this.current = selection;
            }
            if (this.nextButton != null && this.prevButton != null && this.imageIndex != null) {
                this.prevButton.setEnabled(this.current != 0);
                this.nextButton.setEnabled(this.current != this.images.size() - 1);
                this.imageIndex.setText("Screenshot " + (this.current + 1) + " from " + this.images.size());
                this.bar.layout();
            }
        }
    }

    private void generateContent() {
        String value = "";
        if (this.report != null) {
            value = String.valueOf(value) + "\n" + new RcpttReportGenerator(this.report, this.images).generateContent(this.report);
        }
        this.text.setText(value);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DetailsDialog_Title);
        Rectangle bounds = newShell.getBounds();
        newShell.setBounds(bounds.x, bounds.y, 800, 600);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void updateImage(ScrolledComposite sc, int change) {
        int selection = this.current + change;
        if (selection < 0 || selection >= this.images.size()) {
            return;
        }
        this.showImage(this.descriptionField, this.imageControl, selection);
        Point size = this.imageControl.computeSize(-1, -1);
        sc.setMinSize(size);
    }

    private static class ImageEntry {
        byte[] data;
        String description;

        private ImageEntry() {
        }
    }

    private static class RcpttReportGenerator
    extends SimpleReportGenerator {
        private final List<ImageEntry> images;
        private final Report report;

        public RcpttReportGenerator(Report report, List<ImageEntry> images) {
            this.report = report;
            this.images = images;
        }

        public StringBuilder toString(StringBuilder builder, int tabs, EObject obj, String ... ignores) {
            if (obj instanceof AdvancedInformation) {
                String content = new AdvancedInformationGenerator().generateContent((AdvancedInformation)obj);
                builder.append(content);
                return builder;
            }
            return super.toString(builder, tabs, obj, ignores);
        }

        public void printNode(Node infoNode, StringBuilder stringBuilder, int tabs, boolean includeWaitDetails) {
            this.writeQ7Info(stringBuilder, tabs, infoNode);
            if (includeWaitDetails) {
                this.writeQ7WaitInfo(stringBuilder, tabs, infoNode);
            }
            this.writeLogsFromNode(stringBuilder, tabs, infoNode);
            this.printChildren(stringBuilder, tabs, infoNode, includeWaitDetails);
            if (!includeWaitDetails) {
                for (Event child : infoNode.getEvents()) {
                    if (!(child.getData() instanceof EclipseStatus)) continue;
                    this.printStatus((EclipseStatus)child.getData(), tabs + 6, stringBuilder);
                }
                for (Event child : infoNode.getSnapshots()) {
                    if (child.getData() instanceof Screenshot) {
                        Screenshot shot = (Screenshot)child.getData();
                        ImageEntry e = new ImageEntry();
                        e.data = shot.getData();
                        e.description = String.valueOf(shot.getMessage()) + ": " + TimeFormatHelper.format(child.getTime() - this.report.getRoot().getStartTime());
                        this.images.add(e);
                        continue;
                    }
                    this.printSnapshot((Snaphot)child, stringBuilder, tabs + 4);
                }
            }
        }

        private void printChildren(StringBuilder stringBuilder, int tabs, Node infoNode, boolean includeWaitDetails) {
            for (Node child : infoNode.getChildren()) {
                this.printNode(child, stringBuilder, tabs + 4, includeWaitDetails);
            }
        }

        private void writeQ7WaitInfo(StringBuilder stringBuilder, int tabs, Node infoNode) {
            Q7WaitInfoRoot waitInfo = ReportHelper.getWaitInfo((Node)infoNode, (boolean)false);
            if (waitInfo != null) {
                this.printWaitInfo(stringBuilder, tabs, "", waitInfo);
            }
        }

        private void writeQ7Info(StringBuilder stringBuilder, int tabs, Node infoNode) {
            Q7Info q7Info = ReportHelper.getInfo((Node)infoNode);
            this.appendTabs(stringBuilder, tabs);
            if (q7Info != null) {
                switch (q7Info.getType()) {
                    case TESTCASE: {
                        stringBuilder.append(Messages.bind((String)Messages.DetailsDialog_TestCase, (Object)infoNode.getName()));
                        break;
                    }
                    case SCRIPT: {
                        stringBuilder.append(Messages.bind((String)Messages.DetailsDialog_Script, (Object)infoNode.getName()));
                        break;
                    }
                    case CONTEXT: {
                        stringBuilder.append(Messages.bind((String)Messages.DetailsDialog_Context, (Object)infoNode.getName()));
                        break;
                    }
                    case VERIFICATION: {
                        stringBuilder.append(Messages.bind((String)Messages.DetailsDialog_Verifications, (Object)infoNode.getName(), (Object)q7Info.getPhase()));
                        break;
                    }
                    case ECL_COMMAND: {
                        stringBuilder.append(Messages.bind((String)Messages.DetailsDialog_EclCommand, (Object)infoNode.getName()));
                        break;
                    }
                    case TEST_SUITE: {
                        break;
                    }
                }
                stringBuilder.append(" ").append(Messages.bind((String)Messages.DetailsDialog_TimeFragment, (Object)TimeFormatHelper.format(infoNode.getEndTime() - infoNode.getStartTime()))).append(LINE_SEPARATOR);
            }
        }

        private void writeLogsFromNode(StringBuilder builder, int tabs, Node infoNode) {
            boolean haveEntries = false;
            for (LoggingCategory logCategory : LoggingCategory.VALUES) {
                String log = ReportBuilder.getLogs((Node)infoNode, (LoggingCategory)logCategory);
                if (Strings.isNullOrEmpty((String)log)) continue;
                if (!haveEntries) {
                    haveEntries = true;
                    this.appendTabs(builder, tabs).append("--------------Logs BEGIN-------------------").append(LINE_SEPARATOR);
                }
                String[] stringArray = log.split(LINE_SEPARATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String logLine = stringArray[n2];
                    this.appendTabs(builder, tabs).append(logLine).append(LINE_SEPARATOR);
                    ++n2;
                }
            }
            if (haveEntries) {
                this.appendTabs(builder, tabs).append("--------------Logs END-------------------").append(LINE_SEPARATOR);
            }
        }
    }
}

