/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.RemoveFromFileToDateChange;

public class NamedElementMoveParticipant
extends MoveParticipant {
    private Object element;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile destinationFile;
        MoveArguments arguments;
        IContainer destination;
        IFolder destinationFolder;
        CompositeChange change = null;
        if (this.element instanceof IFolder && (destinationFolder = this.getDestinationFolder((IFolder)this.element, destination = (IContainer)(arguments = this.getArguments()).getDestination())) != null && destinationFolder.exists()) {
            change = new CompositeChange(Messages.NamedElementMoveParticipant_ChangeName);
            this.processReplacedFolder((IFolder)this.element, destinationFolder, change);
            if (change.getChildren().length == 0) {
                change = null;
            }
        }
        if (this.element instanceof IFile && (destinationFile = this.getDestinationFile((IFile)this.element, destination = (IContainer)(arguments = this.getArguments()).getDestination())) != null && destinationFile.exists()) {
            if (change == null) {
                change = new CompositeChange(Messages.NamedElementMoveParticipant_ChangeName);
            }
            change.add((Change)new RemoveFromFileToDateChange(destinationFile));
        }
        return change;
    }

    private void processReplacedFolder(IFolder source, IFolder destination, CompositeChange change) throws CoreException {
        IResource[] iResourceArray = source.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder destinationFolder;
            IFile destinationFile;
            IResource sourceChild = iResourceArray[n2];
            if (sourceChild instanceof IFile && (destinationFile = this.getDestinationFile((IFile)sourceChild, (IContainer)destination)) != null && destinationFile.exists()) {
                change.add((Change)new RemoveFromFileToDateChange(destinationFile));
            }
            if (sourceChild instanceof IFolder && (destinationFolder = this.getDestinationFolder((IFolder)sourceChild, (IContainer)destination)) != null && destinationFolder.exists()) {
                this.processReplacedFolder((IFolder)sourceChild, destinationFolder, change);
            }
            ++n2;
        }
    }

    private IFile getDestinationFile(IFile sourceFile, IContainer destination) {
        IPath destinationLocation = destination.getFullPath().append(sourceFile.getFullPath().lastSegment());
        IFile destinationFile = destination.getWorkspace().getRoot().getFile(destinationLocation);
        return destinationFile;
    }

    private IFolder getDestinationFolder(IFolder sourceFolder, IContainer destination) {
        IPath destinationLocation = destination.getFullPath().append(sourceFolder.getFullPath().lastSegment());
        IFolder destinationFolder = destination.getWorkspace().getRoot().getFolder(destinationLocation);
        return destinationFolder;
    }

    public String getName() {
        return Messages.NamedElementMoveParticipant_Name;
    }

    protected boolean initialize(Object element) {
        this.element = element;
        return true;
    }
}

