/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;

public class Q7UpdateSiteExtensions {
    private static Q7UpdateSiteExtensions instance;
    private Map<String, List<Q7RuntimeInfo>> versionToBundles = new HashMap<String, List<Q7RuntimeInfo>>();

    public Q7UpdateSiteExtensions() {
        this.inializeProcessors();
    }

    private void inializeProcessors() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.launching.ext.q7runtime");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String version = config.getAttribute("version");
            IContributor contributor = config.getContributor();
            Q7RuntimeInfo info = new Q7RuntimeInfo();
            info.bundle = contributor.getName();
            info.kind = config.getAttribute("kind");
            info.path = config.getAttribute("path");
            if (info.path == null) {
                Q7ExtLaunchingPlugin.getDefault().log("Plugin " + info.bundle + " provides incorrect q7runtime extension point", null);
            }
            if (!this.versionToBundles.containsKey(version)) {
                this.versionToBundles.put(version, new ArrayList());
            }
            List<Q7RuntimeInfo> list = this.versionToBundles.get(version);
            list.add(info);
            ++n2;
        }
    }

    public static synchronized Q7UpdateSiteExtensions getDefault() {
        if (instance == null) {
            instance = new Q7UpdateSiteExtensions();
        }
        return instance;
    }

    public List<Q7RuntimeInfo> getRuntimes(String version) {
        ArrayList<Q7RuntimeInfo> result = new ArrayList<Q7RuntimeInfo>();
        Set<String> keySet = this.versionToBundles.keySet();
        Version versionValue = Version.create((String)version);
        for (String key : keySet) {
            if (key.equals(version)) {
                result.addAll((Collection<Q7RuntimeInfo>)this.versionToBundles.get(key));
                continue;
            }
            try {
                VersionRange range = new VersionRange(key);
                if (!range.isIncluded(versionValue)) continue;
                result.addAll((Collection<Q7RuntimeInfo>)this.versionToBundles.get(key));
            }
            catch (IllegalArgumentException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        return result;
    }

    public Map<String, List<Q7RuntimeInfo>> getAllKnownVersions() {
        return this.versionToBundles;
    }

    public static class Q7RuntimeInfo {
        public String kind;
        public String path;
        public String bundle;

        public String toString() {
            return this.bundle;
        }
    }
}

