/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.target;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.osgi.framework.Version;

public class TargetPlatformManager {
    public static ITargetPlatformHelper createTargetPlatform(String location, IProgressMonitor monitor) {
        TargetPlatformHelper info = new TargetPlatformHelper();
        try {
            ITargetPlatformService service = PDEHelper.getTargetService();
            ITargetDefinition target = service.newTarget();
            info.setTarget(target);
            ArrayList<IBundleContainer> containers = new ArrayList<IBundleContainer>();
            IBundleContainer installationContainer = service.newProfileContainer(location, null);
            info.setTargetContainer(installationContainer);
            info.getQ7Target().setInstall(installationContainer);
            containers.add(installationContainer);
            IPath pluginsPath = new Path(location).append("plugins");
            File pluginsDir = new File(pluginsPath.toOSString());
            if (pluginsDir.exists() && pluginsDir.isDirectory() && pluginsDir.canRead()) {
                IBundleContainer pluginsContainer = service.newDirectoryContainer(pluginsPath.toOSString());
                containers.add(pluginsContainer);
                info.getQ7Target().pluginsDir = pluginsContainer;
            }
            target.setBundleContainers(containers.toArray(new IBundleContainer[containers.size()]));
            target.resolve(monitor);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (t instanceof StackOverflowError) {
                message = String.format("Invalid eclipse product location: %s", location);
            } else {
                Q7ExtLaunchingPlugin.getDefault().log(t);
            }
            info.setErrorMessage(message);
        }
        return info;
    }

    public static ITargetPlatformHelper getTargetPlatform(String requiredName, IProgressMonitor monitor, boolean needResolve) {
        ITargetHandle[] targets;
        TargetPlatformHelper info = new TargetPlatformHelper();
        ITargetHandle[] iTargetHandleArray = targets = PDEHelper.getTargetService().getTargets(monitor);
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle handle = iTargetHandleArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            ITargetDefinition def = TargetPlatformManager.getTargetDefinition(handle);
            String name = def.getName();
            if (name != null && name.equals(requiredName)) {
                IBundleContainer[] bundleContainers;
                info.setTarget(def);
                IBundleContainer[] iBundleContainerArray = bundleContainers = def.getBundleContainers();
                int n3 = bundleContainers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleContainer container = iBundleContainerArray[n4];
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (container instanceof ProfileBundleContainer) {
                        info.setTargetContainer(container);
                        info.getQ7Target().setInstall(container);
                    } else if (container instanceof DirectoryBundleContainer) {
                        info.getQ7Target().pluginsDir = container;
                    } else {
                        info.getQ7Target().addExtra(container);
                    }
                    ++n4;
                }
                if (!needResolve) break;
                def.resolve(monitor);
                break;
            }
            ++n2;
        }
        return info;
    }

    public static void deleteTargetPlatform(String tName) {
        try {
            ITargetPlatformService service = PDEHelper.getTargetService();
            ITargetHandle[] handles = service.getTargets((IProgressMonitor)new NullProgressMonitor());
            ArrayList<ITargetHandle> toRemove = new ArrayList<ITargetHandle>();
            ITargetHandle[] iTargetHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetDefinition def;
                ITargetHandle iTargetHandle = iTargetHandleArray[n2];
                if (iTargetHandle.exists() && (def = TargetPlatformManager.getTargetDefinition(iTargetHandle)) != null && def.getName() != null && def.getName().equals(tName)) {
                    toRemove.add(iTargetHandle);
                }
                ++n2;
            }
            for (ITargetHandle iTargetHandle : toRemove) {
                service.deleteTarget(iTargetHandle);
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public static void clearTargets() {
        ITargetPlatformService targetService = PDEHelper.getTargetService();
        TargetPlatformService s = (TargetPlatformService)targetService;
        Version version = RcpttCore.getPlatformVersion();
        if (version.getMajor() == 3 && version.getMinor() == 6) {
            try {
                Method method = TargetPlatformService.class.getDeclaredMethod("cleanOrphanedTargetDefinitionProfiles", new Class[0]);
                method.invoke((Object)s, new Object[0]);
                method = TargetPlatformService.class.getDeclaredMethod("garbageCollect", new Class[0]);
                method.invoke((Object)s, new Object[0]);
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
        } else if (version.getMajor() == 3 && version.getMinor() == 7) {
            try {
                P2TargetUtils.cleanOrphanedTargetDefinitionProfiles();
                P2TargetUtils.garbageCollect();
            }
            catch (Throwable e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
    }

    private static ITargetDefinition getTargetDefinition(ITargetHandle handle) {
        block3: {
            try {
                if (handle != null) break block3;
                return null;
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.logWarn(e, "Error loading target definition of %s handle (%s)", handle.getClass().getName(), handle.toString());
                return null;
            }
        }
        return handle.getTargetDefinition();
    }

    public static ITargetPlatformHelper getCurrentTargetPlatform() {
        ITargetPlatformService targetService = PDEHelper.getTargetService();
        TargetPlatformService s = (TargetPlatformService)targetService;
        try {
            TargetPlatformHelper helper;
            ITargetHandle handle = s.getWorkspaceTargetHandle();
            if (handle != null) {
                helper = new TargetPlatformHelper(){

                    @Override
                    public IStatus resolve(IProgressMonitor monitor) {
                        return Status.OK_STATUS;
                    }
                };
                ITargetDefinition definition = TargetPlatformManager.getTargetDefinition(handle);
                helper.setTarget(definition);
                if (helper.isValid() && helper.getTargetPlatformProfilePath() != null) {
                    return helper;
                }
            }
            helper = new TargetPlatformHelper(){

                @Override
                public IStatus resolve(IProgressMonitor monitor) {
                    return Status.OK_STATUS;
                }
            };
            ITargetDefinition selfAUT = s.newDefaultTargetDefinition();
            selfAUT.setName("selfAUT_" + System.currentTimeMillis());
            s.saveTargetDefinition(selfAUT);
            helper.setTarget(selfAUT);
            return helper;
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return null;
        }
    }

    public static TargetPlatformHelper getCurrentTargetPlatformCopy(String copyName) {
        block3: {
            ITargetDefinition targetSource;
            ITargetDefinition targetCopy;
            TargetPlatformHelper helper;
            TargetPlatformService s;
            block4: {
                ITargetPlatformService targetService = PDEHelper.getTargetService();
                s = (TargetPlatformService)targetService;
                ITargetHandle handle = s.getWorkspaceTargetHandle();
                if (handle == null) break block3;
                helper = new TargetPlatformHelper();
                targetCopy = s.newTarget();
                targetSource = TargetPlatformManager.getTargetDefinition(handle);
                if (targetSource != null) break block4;
                return null;
            }
            try {
                s.copyTargetDefinition(targetSource, targetCopy);
                targetCopy.setName(copyName);
                helper.setTarget(targetCopy);
                return helper;
            }
            catch (CoreException e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        return null;
    }
}

