/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player.viewers;

import java.util.ArrayList;
import org.eclipse.rcptt.tesla.ui.IViewerItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeViewerItem
implements IViewerItem {
    private TreeItem item;

    public TreeViewerItem(TreeItem item) {
        this.item = item;
    }

    @Override
    public IViewerItem[] getItems() {
        if (this.item.isDisposed() || this.item.getParent().isDisposed()) {
            return new IViewerItem[0];
        }
        TreeItem[] items = this.item.getItems();
        return this.toArray(items);
    }

    private IViewerItem[] toArray(TreeItem[] items) {
        ArrayList<TreeViewerItem> result = new ArrayList<TreeViewerItem>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item != null) {
                result.add(new TreeViewerItem(item));
            }
            ++n2;
        }
        return result.toArray(new IViewerItem[result.size()]);
    }

    @Override
    public IViewerItem[] getParentItems() {
        TreeItem parentItem = this.item.getParentItem();
        if (parentItem != null) {
            if (parentItem.isDisposed()) {
                return new IViewerItem[0];
            }
            return this.toArray(parentItem.getItems());
        }
        return this.toArray(this.item.getParent().getItems());
    }

    @Override
    public String getText(int column) {
        if (this.item.isDisposed()) {
            return "";
        }
        return this.item.getText(column);
    }

    @Override
    public String getText() {
        if (this.item.isDisposed()) {
            return "";
        }
        return this.item.getText();
    }

    @Override
    public boolean matches(Object o) {
        if (o instanceof TreeViewerItem) {
            return this.item.equals(((TreeViewerItem)o).item);
        }
        return this.item.equals(o);
    }

    public Tree getControl() {
        return this.item.getParent();
    }

    public TreeItem getItem() {
        return this.item;
    }
}

