/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl;

import java.util.Stack;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeIterator {
    private Widget tree;
    private Item item;
    private Item[] currentItems;
    int itemInd = 0;
    private Stack<Item> itemPath = new Stack();
    private Stack<Integer> itemInds = new Stack();

    public TreeIterator(Widget tree) {
        this.tree = tree;
        this.currentItems = TableTreeUtil.getItems((Widget)this.tree);
        this.item = this.toFirstItem();
    }

    public Item nextInto() {
        if (this.tree instanceof Tree) {
            this.stepInto();
            if (this.getItemsCount() == 0) {
                return this.stepReturn();
            }
            return this.item;
        }
        return this.nextOver();
    }

    public Item nextOver() {
        ++this.itemInd;
        if (this.currentItems.length > this.itemInd) {
            this.item = this.currentItems[this.itemInd];
            return this.getItem();
        }
        return null;
    }

    public Item stepReturn() {
        do {
            this.stepOut();
        } while (this.itemPath.size() > 0 && this.itemInd >= this.currentItems.length - 1);
        Item next = this.nextOver();
        if (next == null && !this.isEnd()) {
            return this.stepReturn();
        }
        return next;
    }

    public Item toFirstItem() {
        this.itemInd = 0;
        if (this.currentItems.length > 0) {
            return this.currentItems[0];
        }
        return null;
    }

    public int getNestingLevel() {
        return this.itemPath.size();
    }

    public Item getItem() {
        return this.item;
    }

    public int getItemIndex() {
        return this.itemInd;
    }

    public String getNonBlankItemPath() {
        return this.getNonBlankItemPath(false);
    }

    public String getNonBlankPath() {
        return this.getNonBlankItemPath(true);
    }

    public String getNonBlankItemPath(boolean pathOnly) {
        StringBuilder sb = new StringBuilder();
        for (Item curItem : this.itemPath) {
            sb.append(this.appendNonBlankItemText(curItem));
            sb.append("/");
        }
        if (!pathOnly) {
            sb.append(this.appendNonBlankItemText(this.item));
        } else if (this.itemPath.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String appendNonBlankItemText(Item item) {
        StringBuilder sb = new StringBuilder();
        String[] vals = TableTreeUtil.getValues((Item)item);
        int i = 0;
        while (i < vals.length) {
            if (!vals[i].equals("")) {
                sb.append(vals[i]);
                if (i == 0) break;
                String colName = TableTreeUtil.getName((Widget)TableTreeUtil.getColumn((Widget)this.tree, (int)i));
                sb.append(String.format("(column \"%s\")", colName));
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    private String getFullItemPath(boolean pathOnly) {
        StringBuilder sb = new StringBuilder();
        for (Item curItem : this.itemPath) {
            sb.append(curItem.getText()).append("/");
        }
        if (!pathOnly) {
            sb.append(this.item.getText());
        } else if (this.itemPath.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getFullItemPath() {
        return this.getFullItemPath(false);
    }

    public String getPath() {
        return this.itemPath.size() > 0 ? this.getFullItemPath(true) : null;
    }

    public int getItemsCount() {
        return this.currentItems.length;
    }

    private void stepInto() {
        if (this.tree instanceof Tree) {
            Viewers.expandTreeItem((TreeItem)((TreeItem)this.item));
        }
        this.itemPath.push(this.item);
        this.itemInds.push(this.itemInd);
        this.currentItems = TableTreeUtil.getChildren((Widget)this.item);
        this.item = this.toFirstItem();
    }

    private void stepOut() {
        if (this.itemPath.size() > 0) {
            this.item = this.itemPath.pop();
            this.itemInd = this.itemInds.pop();
            this.currentItems = this.itemPath.size() == 0 ? TableTreeUtil.getItems((Widget)this.tree) : TableTreeUtil.getChildren((Widget)((Widget)this.itemPath.peek()));
        }
    }

    public boolean isEnd() {
        return this.currentItems.length <= this.itemInd && this.itemPath.empty();
    }
}

