/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.widgets.Display;

public class ContentChangeNotifier
implements IContentChangeNotifier {
    private ListenerList fListenerList;
    private final IContentChangeNotifier element;

    public ContentChangeNotifier(IContentChangeNotifier element) {
        this.element = element;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    public void fireContentChanged() {
        if (this.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Object[] listeners = ContentChangeNotifier.this.fListenerList.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IContentChangeListener contentChangeListener = (IContentChangeListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, contentChangeListener){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IContentChangeListener val$contentChangeListener;
                        {
                            this.this$1 = var1_1;
                            this.val$contentChangeListener = iContentChangeListener;
                        }

                        public void run() throws Exception {
                            this.val$contentChangeListener.contentChanged(ContentChangeNotifier.access$1(1.access$0(this.this$1)));
                        }

                        public void handleException(Throwable exception) {
                        }
                    });
                    ++i;
                }
            }

            static /* synthetic */ ContentChangeNotifier access$0(1 var0) {
                return var0.ContentChangeNotifier.this;
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean isEmpty() {
        return this.fListenerList == null || this.fListenerList.isEmpty();
    }

    static /* synthetic */ IContentChangeNotifier access$1(ContentChangeNotifier contentChangeNotifier) {
        return contentChangeNotifier.element;
    }
}

