/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

abstract class FS_POSIX
extends FS {
    protected File discoverGitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe != null) {
            return gitExe.getParentFile().getParentFile();
        }
        if (FS_POSIX.isMacOS()) {
            String w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            if (w == null || w.length() == 0) {
                return null;
            }
            File parentFile = new File(w).getParentFile();
            if (parentFile == null) {
                return null;
            }
            return parentFile.getParentFile();
        }
        return null;
    }

    FS_POSIX() {
    }

    FS_POSIX(FS src) {
        super(src);
    }

    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    private static boolean isMacOS() {
        String osDotName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        return "Mac OS X".equals(osDotName);
    }
}

