/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.ctx.resources.WorkspaceContextImporter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;

public class ImportUtils {
    public static void importFiles(WSFolder ownFolder, EList<WSFile> files, IPersistenceModel model, WorkspaceContextImporter importer) {
        for (WSFile wsFile : files) {
            WSFile ownFile = WSUtils.getFile(ownFolder, wsFile.getName(), true);
            ownFile.setExecutable(wsFile.isExecutable());
            String name = ImportUtils.getName(ownFile);
            InputStream stream = importer.getContents(wsFile);
            if (stream == null) continue;
            OutputStream result = model.store(name);
            if (result != null) {
                try {
                    FileUtil.copy((InputStream)stream, (OutputStream)result);
                }
                catch (Exception e) {
                    RcpttPlugin.log((Throwable)e);
                }
                continue;
            }
            RcpttPlugin.log((String)("Failed to import: " + wsFile.getName() + " node: " + name), (Throwable)new Exception());
        }
    }

    public static String getName(WSFile ownFile) {
        StringBuilder builder = new StringBuilder();
        builder.append(ownFile.getName());
        EObject ct = ownFile.eContainer();
        while (ct != null) {
            if (ct instanceof WSFolder) {
                builder.insert(0, String.valueOf(((WSFolder)ct).getName()) + "/");
            }
            ct = ct.eContainer();
        }
        return "contents/" + builder.toString();
    }

    public static void importFolders(WSFolder ownProject, EList<WSFolder> folders, IPersistenceModel model, WorkspaceContextImporter importer) {
        for (WSFolder wsFolder : folders) {
            WSFolder ownFolder = WSUtils.getFolder(ownProject, wsFolder.getName(), true);
            ImportUtils.importFolders(ownFolder, wsFolder.getFolders(), model, importer);
            ImportUtils.importFiles(ownFolder, wsFolder.getFiles(), model, importer);
        }
    }
}

