/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResultStatus implements Enumerator
{
    PASS(0, "Pass", "Pass"),
    FAIL(1, "Fail", "Fail"),
    WARN(2, "Warn", "Warn"),
    SKIPPED(3, "Skipped", "Skipped");

    public static final int PASS_VALUE = 0;
    public static final int FAIL_VALUE = 1;
    public static final int WARN_VALUE = 2;
    public static final int SKIPPED_VALUE = 3;
    private static final ResultStatus[] VALUES_ARRAY;
    public static final List<ResultStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResultStatus[]{PASS, FAIL, WARN, SKIPPED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResultStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultStatus get(int value) {
        switch (value) {
            case 0: {
                return PASS;
            }
            case 1: {
                return FAIL;
            }
            case 2: {
                return WARN;
            }
            case 3: {
                return SKIPPED;
            }
        }
        return null;
    }

    private ResultStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

