/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.reporting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.reporting.IEventProvider;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;

public abstract class AbstractEventProvider
implements IEventProvider {
    private List<IReportBuilder> listeners = new ArrayList<IReportBuilder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IReportBuilder builder) {
        List<IReportBuilder> list = this.listeners;
        synchronized (list) {
            this.listeners.add(builder);
        }
        this.initializeBuilder(builder);
    }

    protected abstract void initializeBuilder(IReportBuilder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IReportBuilder builder) {
        List<IReportBuilder> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(builder);
            if (this.listeners.isEmpty()) {
                this.doneBuilders();
            }
        }
    }

    protected void doneBuilders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IReportBuilder[] getListeners() {
        IReportBuilder[] result = null;
        List<IReportBuilder> list = this.listeners;
        synchronized (list) {
            result = this.listeners.toArray(new IReportBuilder[this.listeners.size()]);
        }
        return result;
    }

    protected void logEvent(Event event) {
        IReportBuilder[] iReportBuilderArray = this.getListeners();
        int n = iReportBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }
}

