/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.ContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.internal.core.ECFPlugin;

public abstract class AbstractContainer
implements IContainer {
    private final List containerListeners = new ArrayList(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IContainerListener l) {
        List list = this.containerListeners;
        synchronized (list) {
            this.containerListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IContainerListener l) {
        List list = this.containerListeners;
        synchronized (list) {
            this.containerListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.fireContainerEvent(new ContainerDisposeEvent(this.getID()));
        List list = this.containerListeners;
        synchronized (list) {
            this.containerListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContainerEvent(IContainerEvent event) {
        ArrayList toNotify = null;
        List list = this.containerListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.containerListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IContainerListener l = (IContainerListener)i.next();
            l.handleEvent(event);
        }
    }

    public Object getAdapter(Class serviceType) {
        if (serviceType == null) {
            return null;
        }
        if (serviceType.isInstance(this)) {
            return this;
        }
        ECFPlugin plugin = ECFPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        IAdapterManager adapterManager = plugin.getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, serviceType.getName());
    }

    protected String getPasswordFromConnectContext(IConnectContext connectContext) throws ContainerConnectException {
        String pw = null;
        try {
            CallbackHandler handler;
            Callback[] callbacks = new Callback[]{new ObjectCallback()};
            if (connectContext != null && (handler = connectContext.getCallbackHandler()) != null) {
                handler.handle(callbacks);
            }
            ObjectCallback cb = (ObjectCallback)callbacks[0];
            pw = (String)cb.getObject();
        }
        catch (Exception e) {
            throw new ContainerConnectException("Exception in CallbackHandler.handle(<callbacks>)", e);
        }
        return pw;
    }
}

