/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.operations.IBatchFeatureOperation;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationListener;

public abstract class BatchFeatureOperation
extends Operation
implements IBatchFeatureOperation {
    private IFeature[] features;
    private IConfiguredSite[] targetSites;

    public BatchFeatureOperation(IConfiguredSite[] targetSites, IFeature[] features) {
        this.features = features;
        this.targetSites = targetSites;
    }

    public IFeature[] getFeatures() {
        return this.features;
    }

    public IConfiguredSite[] getTargetSites() {
        return this.targetSites;
    }

    public void setTargetSites(IConfiguredSite[] targetSites) {
        this.targetSites = targetSites;
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException, InvocationTargetException {
        if (this.getFeatures() == null || this.getFeatures().length == 0) {
            return false;
        }
        IOperation[] operations = new IOperation[this.getFeatures().length];
        int i = 0;
        while (i < this.getFeatures().length) {
            operations[i] = this.createOperation(this.getTargetSites()[i], this.getFeatures()[i]);
            ++i;
        }
        boolean restartNeeded = false;
        int i2 = 0;
        while (i2 < operations.length) {
            try {
                boolean status = operations[i2].execute(pm, listener);
                if (status) {
                    restartNeeded = true;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i2;
        }
        return restartNeeded;
    }

    protected abstract IOperation createOperation(IConfiguredSite var1, IFeature var2);
}

