/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IRevertConfigurationOperation;
import org.eclipse.update.operations.OperationsManager;

public class RevertConfigurationOperation
extends Operation
implements IRevertConfigurationOperation {
    private IInstallConfiguration config;
    private IProblemHandler problemHandler;

    public RevertConfigurationOperation(IInstallConfiguration config, IProblemHandler problemHandler) {
        this.config = config;
        this.problemHandler = problemHandler;
    }

    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException, InvocationTargetException {
        IStatus status = OperationsManager.getValidator().validatePendingRevert(this.config);
        if (status != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            localSite.revertTo(this.config, monitor, this.problemHandler);
            localSite.save();
            return true;
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
            throw e;
        }
    }
}

