/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.AbstractHtmlBlock;

public class SourceBlock
extends AbstractHtmlBlock {
    private String lang;

    public SourceBlock() {
        super("source");
    }

    protected void setAttributes(String attributes) {
        if (attributes != null) {
            Pattern pattern = Pattern.compile("\\s+([a-zA-Z][a-zA-Z0-9_:-]*)=\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(attributes);
            while (matcher.find()) {
                String attrName = matcher.group(1);
                String attrValue = matcher.group(2);
                this.handleAttribute(attrName, attrValue);
            }
        }
    }

    protected void handleAttribute(String attrName, String attrValue) {
        if (attrName.equalsIgnoreCase("lang")) {
            this.lang = attrValue;
        }
    }

    protected void beginBlock() {
        Attributes attributes = new Attributes();
        if (this.lang != null) {
            attributes.setCssClass("source-" + this.lang);
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
    }

    protected void endBlock() {
        this.builder.endBlock();
    }

    protected void handleBlockContent(String content) {
        if (content.length() > 0) {
            this.builder.characters(content);
        } else if (this.blockLineCount == 1) {
            return;
        }
        this.builder.characters("\n");
    }
}

