/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Get;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.ImageFetchingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlSourceImageFetchingStrategy
extends ImageFetchingStrategy {
    private String base;
    private File src;

    HtmlSourceImageFetchingStrategy() {
    }

    @Override
    public Set<String> fetchImages() {
        String htmlSrc;
        if (!this.src.exists()) {
            throw new BuildException("@src does not exist: " + this.src);
        }
        if (!this.src.isFile()) {
            throw new BuildException("@src is not a file: " + this.src);
        }
        if (this.base == null) {
            throw new BuildException("Must specify @base");
        }
        if (this.base.endsWith("/")) {
            this.base = this.base.substring(0, this.base.length() - 1);
        }
        HashSet<String> filenames = new HashSet<String>();
        Pattern fragmentUrlPattern = Pattern.compile("src=\"([^\"]+)\"");
        Pattern imagePattern = Pattern.compile("alt=\"Image:([^\"]*)\"([^>]+)", 8);
        try {
            htmlSrc = this.readSrc();
        }
        catch (IOException e) {
            throw new BuildException("Cannot read src: " + this.src + ": " + e.getMessage(), (Throwable)e);
        }
        this.log("Parsing " + this.src, 2);
        int fileCount = 0;
        Matcher imagePatternMatcher = imagePattern.matcher(htmlSrc);
        while (imagePatternMatcher.find()) {
            Matcher fragmentUrlMatcher;
            String alt = imagePatternMatcher.group(1);
            String imageFragment = imagePatternMatcher.group(2);
            if (imageFragment == null || !(fragmentUrlMatcher = fragmentUrlPattern.matcher(imageFragment)).find()) continue;
            String url = fragmentUrlMatcher.group(1);
            String qualifiedUrl = String.valueOf(this.base) + url;
            this.log("Fetching " + qualifiedUrl, 2);
            Get get = new Get();
            get.setProject(this.getProject());
            get.setLocation(this.getLocation());
            try {
                get.setSrc(new URL(qualifiedUrl));
            }
            catch (MalformedURLException e) {
                this.log("Skipping " + url + ": " + e.getMessage(), 1);
                continue;
            }
            String name = alt == null ? url.substring(url.lastIndexOf(47)) : alt;
            name = name.replace(' ', '_');
            get.setDest(new File(this.dest, name));
            get.execute();
            filenames.add(name);
            ++fileCount;
        }
        this.log("Fetched " + fileCount + " image files for " + this.src, 2);
        return filenames;
    }

    private String readSrc() throws IOException {
        StringBuilder buf = new StringBuilder((int)this.src.length());
        BufferedReader reader = new BufferedReader(new FileReader(this.src));
        try {
            int i;
            while ((i = ((Reader)reader).read()) != -1) {
                buf.append((char)i);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return buf.toString();
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File src) {
        this.src = src;
    }
}

