/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.variants.CachedResourceVariant;

abstract class GitRemoteResource
extends CachedResourceVariant {
    private final String path;
    private final RevCommit commitId;
    private final ObjectId objectId;

    GitRemoteResource(RevCommit commitId, ObjectId objectId, String path) {
        this.path = path;
        this.objectId = objectId;
        this.commitId = commitId;
    }

    public String getName() {
        int lastSeparator = this.path.lastIndexOf("/");
        return this.path.substring(lastSeparator + 1, this.path.length());
    }

    public String getContentIdentifier() {
        return String.valueOf(this.commitId.abbreviate(7).name()) + "...";
    }

    public byte[] asBytes() {
        return this.getObjectId().name().getBytes();
    }

    protected String getCachePath() {
        return this.path;
    }

    protected String getCacheId() {
        return "org.eclipse.egit";
    }

    boolean exists() {
        return this.commitId != null;
    }

    RevCommit getCommitId() {
        return this.commitId;
    }

    ObjectId getObjectId() {
        return this.objectId != null ? this.objectId : ObjectId.zeroId();
    }

    String getPath() {
        return this.path;
    }
}

