/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.model.PluginModel;

public class PluginMap {
    private Map map;
    private boolean preserveOrder;
    private int size;
    private boolean replaceDuplicates;

    public PluginMap(Map pluginModels) {
        this(pluginModels, true, false);
    }

    public PluginMap(Map pluginModels, boolean preserveOrder, boolean replaceDuplicates) {
        this.map = pluginModels;
        this.preserveOrder = preserveOrder;
        this.replaceDuplicates = replaceDuplicates;
    }

    public void add(PluginModel pluginModel) {
        String key = pluginModel.getId();
        LinkedList<PluginModel> verList = (LinkedList<PluginModel>)this.map.get(key);
        if (verList == null) {
            verList = new LinkedList<PluginModel>();
            this.map.put(key, verList);
        }
        int i = 0;
        if (this.preserveOrder) {
            while (i < verList.size()) {
                PluginModel element = (PluginModel)verList.get(i);
                if (this.getVersionIdentifier(pluginModel).equals((Object)this.getVersionIdentifier(element))) {
                    if (this.replaceDuplicates) {
                        verList.set(i, pluginModel);
                    }
                    return;
                }
                if (this.getVersionIdentifier(pluginModel).isGreaterThan(this.getVersionIdentifier(element))) break;
                ++i;
            }
        }
        verList.add(i, pluginModel);
        ++this.size;
    }

    public PluginModel get(String id, String version) {
        List versions = (List)this.map.get(id);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        if (version == null) {
            return (PluginModel)versions.get(0);
        }
        int versionCount = versions.size();
        int i = 0;
        while (i < versionCount) {
            PluginModel pluginModel = (PluginModel)versions.get(i);
            if (pluginModel.getVersion().equals(version)) {
                return pluginModel;
            }
            ++i;
        }
        return null;
    }

    public List getVersions(String id) {
        return (List)this.map.get(id);
    }

    public PluginModel getAny(String id) {
        List versions = (List)this.map.get(id);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        return (PluginModel)versions.get(0);
    }

    private PluginVersionIdentifier getVersionIdentifier(PluginModel model) {
        if (PluginVersionIdentifier.validateVersion((String)model.getVersion()).getSeverity() != 0) {
            return new PluginVersionIdentifier("0.0.0");
        }
        return new PluginVersionIdentifier(model.getVersion());
    }

    public int size() {
        return this.size;
    }

    public void markReadOnly() {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            int count = list.size();
            int i = 0;
            while (i < count) {
                ((PluginModel)list.get(i)).markReadOnly();
                ++i;
            }
        }
    }

    public PluginModel remove(String pluginId, String version) {
        List versions = (List)this.map.get(pluginId);
        if (versions == null) {
            return null;
        }
        Iterator iter = versions.iterator();
        while (iter.hasNext()) {
            PluginModel pluginModel = (PluginModel)iter.next();
            if (!pluginModel.getId().equals(pluginId) || !pluginModel.getVersion().equals(version)) continue;
            if (versions.size() == 1) {
                this.map.remove(pluginId);
            } else {
                iter.remove();
            }
            --this.size;
            return pluginModel;
        }
        return null;
    }

    public void removeVersions(String pluginId) {
        List versions = (List)this.map.remove(pluginId);
        if (versions != null) {
            this.size -= versions.size();
        }
    }

    public void copyToArray(Object[] array) {
        int index = 0;
        Iterator mapIter = this.map.values().iterator();
        while (mapIter.hasNext()) {
            List versions = (List)mapIter.next();
            Iterator listIiter = versions.iterator();
            while (listIiter.hasNext()) {
                array[index++] = listIiter.next();
            }
        }
    }
}

