/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;

public class ItemLocation {
    private static final int NO_INDEX = 0;
    private final String text;
    private final int index;
    private static final Pattern indexedFragment = Pattern.compile("^(.*)%(\\d+)%$");

    private ItemLocation(String text, int index) {
        assert (index >= 0);
        this.text = text;
        this.index = index;
    }

    private ItemLocation(String text) {
        this(text, 0);
    }

    private ItemLocation(int index) {
        this(null, index);
    }

    public String toPathFragment() {
        if (this.text == null) {
            throw new IllegalStateException("Null text is not expected");
        }
        return this.index == 0 ? SWTUIPlayer.buildPathFragment((String)this.text) : SWTUIPlayer.buildPathFragment((String)this.text, (int)this.index);
    }

    public static ItemLocation fromPathFragment(String path) {
        Matcher m = indexedFragment.matcher(path);
        return m.matches() ? new ItemLocation(m.group(1), Integer.parseInt(m.group(2))) : new ItemLocation(path);
    }

    public static ItemLocation fromItem(ExpandItem item) {
        ExpandItem[] items = item.getParent().getItems();
        int matchCount = 0;
        ExpandItem[] expandItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandItem sibling = expandItemArray[n2];
            if (sibling == item) break;
            if (sibling.getText().equals(item.getText())) {
                ++matchCount;
            }
            ++n2;
        }
        return new ItemLocation(item.getText(), matchCount);
    }

    public static ItemLocation fromIndex(int index) {
        return new ItemLocation(null, index);
    }

    public static ItemLocation fromSelectionFilter(PlayerSelectionFilter f) {
        return f.path == null || f.path.length == 0 ? ItemLocation.fromIndex(f.index == null ? 0 : f.index) : ItemLocation.fromPathFragment(f.path[0]);
    }

    public ExpandItem findMatch(ExpandBar bar) {
        ExpandItem item;
        if (this.text == null) {
            return bar.getItemCount() > this.index ? bar.getItem(this.index) : null;
        }
        ExpandItem[] expandItemArray = bar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = expandItemArray[n2];
            if (this.matchesExactly(item)) {
                return item;
            }
            ++n2;
        }
        expandItemArray = bar.getItems();
        n = expandItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = expandItemArray[n2];
            if (this.regexMatches(item)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public boolean matchesExactly(ExpandItem item) {
        return this.equals(ItemLocation.fromItem(item));
    }

    public boolean regexMatches(ExpandItem item) {
        if (this.text == null) {
            return false;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(this.text);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        int matchIndex = -1;
        ExpandItem[] expandItemArray = item.getParent().getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpandItem sibling = expandItemArray[n2];
            if (pattern.matcher(sibling.getText()).matches()) {
                ++matchIndex;
                if (sibling == item) {
                    return this.index == matchIndex;
                }
            }
            ++n2;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemLocation other = (ItemLocation)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

