/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.io.IOException;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public abstract class RegexpMatcherTest
extends TestCase {
    public static final String UNIX_LINE = "\n";
    private RegexpMatcher reg;

    public abstract RegexpMatcher getImplementation();

    protected final RegexpMatcher getReg() {
        return this.reg;
    }

    public RegexpMatcherTest(String name) {
        super(name);
    }

    public void setUp() {
        this.reg = this.getImplementation();
    }

    public void testMatches() {
        this.reg.setPattern("aaaa");
        RegexpMatcherTest.assertTrue((String)"aaaa should match itself", (boolean)this.reg.matches("aaaa"));
        RegexpMatcherTest.assertTrue((String)"aaaa should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        RegexpMatcherTest.assertTrue((String)"aaaa shouldn't match xaaa", (!this.reg.matches("xaaa") ? 1 : 0) != 0);
        this.reg.setPattern("^aaaa");
        RegexpMatcherTest.assertTrue((String)"^aaaa shouldn't match xaaaa", (!this.reg.matches("xaaaa") ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"^aaaa should match aaaax", (boolean)this.reg.matches("aaaax"));
        this.reg.setPattern("aaaa$");
        RegexpMatcherTest.assertTrue((String)"aaaa$ shouldn't match aaaax", (!this.reg.matches("aaaax") ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"aaaa$ should match xaaaa", (boolean)this.reg.matches("xaaaa"));
        this.reg.setPattern("[0-9]+");
        RegexpMatcherTest.assertTrue((String)"[0-9]+ should match 123", (boolean)this.reg.matches("123"));
        RegexpMatcherTest.assertTrue((String)"[0-9]+ should match 1", (boolean)this.reg.matches("1"));
        RegexpMatcherTest.assertTrue((String)"[0-9]+ shouldn't match ''", (!this.reg.matches("") ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"[0-9]+ shouldn't match a", (!this.reg.matches("a") ? 1 : 0) != 0);
        this.reg.setPattern("[0-9]*");
        RegexpMatcherTest.assertTrue((String)"[0-9]* should match 123", (boolean)this.reg.matches("123"));
        RegexpMatcherTest.assertTrue((String)"[0-9]* should match 1", (boolean)this.reg.matches("1"));
        RegexpMatcherTest.assertTrue((String)"[0-9]* should match ''", (boolean)this.reg.matches(""));
        RegexpMatcherTest.assertTrue((String)"[0-9]* should match a", (boolean)this.reg.matches("a"));
        this.reg.setPattern("([0-9]+)=\\1");
        RegexpMatcherTest.assertTrue((String)"([0-9]+)=\\1 should match 1=1", (boolean)this.reg.matches("1=1"));
        RegexpMatcherTest.assertTrue((String)"([0-9]+)=\\1 shouldn't match 1=2", (!this.reg.matches("1=2") ? 1 : 0) != 0);
    }

    public void testGroups() {
        this.reg.setPattern("aaaa");
        Vector v = this.reg.getGroups("xaaaa");
        RegexpMatcherTest.assertEquals((String)"No parens -> no extra groups", (int)1, (int)v.size());
        RegexpMatcherTest.assertEquals((String)"Trivial match with no parens", (String)"aaaa", (String)((String)v.elementAt(0)));
        this.reg.setPattern("(aaaa)");
        v = this.reg.getGroups("xaaaa");
        RegexpMatcherTest.assertEquals((String)"Trivial match with single paren", (int)2, (int)v.size());
        RegexpMatcherTest.assertEquals((String)"Trivial match with single paren, full match", (String)"aaaa", (String)((String)v.elementAt(0)));
        RegexpMatcherTest.assertEquals((String)"Trivial match with single paren, matched paren", (String)"aaaa", (String)((String)v.elementAt(0)));
        this.reg.setPattern("(a+)b(b+)");
        v = this.reg.getGroups("xaabb");
        RegexpMatcherTest.assertEquals((int)3, (int)v.size());
        RegexpMatcherTest.assertEquals((String)"aabb", (String)((String)v.elementAt(0)));
        RegexpMatcherTest.assertEquals((String)"aa", (String)((String)v.elementAt(1)));
        RegexpMatcherTest.assertEquals((String)"b", (String)((String)v.elementAt(2)));
    }

    public void testBugzillaReport14619() {
        this.reg.setPattern("^(.*)/src/((.*/)*)([a-zA-Z0-9_\\.]+)\\.java$");
        Vector v = this.reg.getGroups("de/tom/src/Google.java");
        RegexpMatcherTest.assertEquals((int)5, (int)v.size());
        RegexpMatcherTest.assertEquals((Object)"de/tom", v.elementAt(1));
        RegexpMatcherTest.assertEquals((Object)"", v.elementAt(2));
        RegexpMatcherTest.assertEquals((Object)"", v.elementAt(3));
        RegexpMatcherTest.assertEquals((Object)"Google", v.elementAt(4));
    }

    public void testCaseInsensitiveMatch() {
        this.reg.setPattern("aaaa");
        RegexpMatcherTest.assertTrue((String)"aaaa doesn't match AAaa", (!this.reg.matches("AAaa") ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"aaaa matches AAaa ignoring case", (boolean)this.reg.matches("AAaa", 256));
    }

    public void testParagraphCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"paragraph character", (!this.reg.matches("end of text\u2029") ? 1 : 0) != 0);
    }

    public void testLineSeparatorCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"line-separator character", (!this.reg.matches("end of text\u2028") ? 1 : 0) != 0);
    }

    public void testNextLineCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"next-line character", (!this.reg.matches("end of text\u0085") ? 1 : 0) != 0);
    }

    public void testStandaloneCR() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"standalone CR", (!this.reg.matches("end of text\r") ? 1 : 0) != 0);
    }

    public void testWindowsLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"Windows line separator", (!this.reg.matches("end of text\r\n") ? 1 : 0) != 0);
    }

    public void testWindowsLineSeparator2() throws IOException {
        this.reg.setPattern("end of text\r$");
        RegexpMatcherTest.assertTrue((String)"Windows line separator", (boolean)this.reg.matches("end of text\r\n"));
    }

    public void testUnixLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue((String)"Unix line separator", (boolean)this.reg.matches("end of text\n"));
    }

    public void testMultiVersusSingleLine() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("Line1").append(UNIX_LINE);
        buf.append("starttest Line2").append(UNIX_LINE);
        buf.append("Line3 endtest").append(UNIX_LINE);
        buf.append("Line4").append(UNIX_LINE);
        String text = buf.toString();
        this.doStartTest1(text);
        this.doStartTest2(text);
        this.doEndTest1(text);
        this.doEndTest2(text);
    }

    protected void doStartTest1(String text) {
        this.reg.setPattern("^starttest");
        RegexpMatcherTest.assertTrue((String)"^starttest in default mode", (!this.reg.matches(text) ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"^starttest in single line mode", (!this.reg.matches(text, 65536) ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"^starttest in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doStartTest2(String text) {
        this.reg.setPattern("^Line1");
        RegexpMatcherTest.assertTrue((String)"^Line1 in default mode", (boolean)this.reg.matches(text));
        RegexpMatcherTest.assertTrue((String)"^Line1 in single line mode", (boolean)this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue((String)"^Line1 in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest1(String text) {
        this.reg.setPattern("endtest$");
        RegexpMatcherTest.assertTrue((String)"endtest$ in default mode", (!this.reg.matches(text) ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"endtest$ in single line mode", (!this.reg.matches(text, 65536) ? 1 : 0) != 0);
        RegexpMatcherTest.assertTrue((String)"endtest$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }

    protected void doEndTest2(String text) {
        this.reg.setPattern("Line4$");
        RegexpMatcherTest.assertTrue((String)"Line4$ in default mode", (boolean)this.reg.matches(text));
        RegexpMatcherTest.assertTrue((String)"Line4$ in single line mode", (boolean)this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue((String)"Line4$ in multi line mode", (boolean)this.reg.matches(text, 4096));
    }
}

