/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.deltas;

import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.Q7ElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Project;

public class ModelUpdater {
    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                Q7ElementInfo info = (Q7ElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (ModelException modelException) {}
    }

    protected void elementAdded(Openable element) {
        IQ7Element.HandleType elementType = element.getElementType();
        if (elementType.equals((Object)IQ7Element.HandleType.Project)) {
            this.addToParentInfo(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        IQ7Element.HandleType elementType = element.getElementType();
        switch (elementType) {
            case Model: {
                ModelManager.getModelManager().getIndexManager().reset();
                break;
            }
            case Project: {
                break;
            }
            case Folder: {
                Q7Project project = (Q7Project)element.getQ7Project();
                project.resetCaches();
            }
        }
    }

    public void processDelta(IQ7ElementDelta delta) {
        this.traverseDelta(delta, null);
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                Q7ElementInfo info = (Q7ElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    protected void traverseDelta(IQ7ElementDelta delta, IQ7Project project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case Project: {
                project = (IQ7Project)((Object)element);
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IQ7ElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IQ7ElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, project);
                ++i;
            }
        }
    }
}

