/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.sourcelookup;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.SourceLookupDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class CommonSourceNotFoundEditor
extends EditorPart
implements IReusableEditor {
    private Text fText;
    private ILaunchesListener2 fLaunchesListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.initialize();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridLayout topLayout = new GridLayout();
        GridData data = new GridData();
        topLayout.numColumns = 1;
        topLayout.verticalSpacing = 10;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)data);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.fText = new Text(parent, 72);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fText.setLayoutData((Object)data);
        this.fText.setForeground(JFaceColors.getErrorText((Display)this.fText.getDisplay()));
        this.fText.setBackground(parent.getDisplay().getSystemColor(1));
        if (this.getEditorInput() != null) {
            this.setInput(this.getEditorInput());
        }
        this.createButtons(parent);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.debugger_editor_no_source_common");
    }

    protected void createButtons(Composite parent) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)data);
        button.setText(SourceLookupUIMessages.addSourceLocation_addButton2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonSourceNotFoundEditor.this.editSourceLookupPath();
            }
        });
    }

    protected void editSourceLookupPath() {
        ISourceLocator locator = null;
        ILaunch launch = null;
        IAdaptable selection = DebugUITools.getDebugContext();
        if (selection == null) {
            new MessageDialog(this.getSite().getShell(), SourceLookupUIMessages.CommonSourceNotFoundEditor_0, null, SourceLookupUIMessages.CommonSourceNotFoundEditor_1, 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.ILaunch");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (selection.getAdapter((Class)clazz) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.debug.core.ILaunch");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            launch = (ILaunch)selection.getAdapter((Class)clazz2);
            locator = launch.getSourceLocator();
        } else {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (selection.getAdapter((Class)clazz3) != null) {
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                launch = ((IDebugElement)selection.getAdapter((Class)clazz4)).getLaunch();
                locator = launch.getSourceLocator();
            } else {
                return;
            }
        }
        if (locator == null || !(locator instanceof AbstractSourceLookupDirector)) {
            return;
        }
        SourceLookupDialog dialog = new SourceLookupDialog(DebugUIPlugin.getShell(), (ISourceLookupDirector)((AbstractSourceLookupDirector)locator));
        if (dialog.open() == 0) {
            IWorkbenchPage page = this.getEditorSite().getPage();
            SourceLookupManager.getDefault().displaySource(this.getArtifact(), page, true);
            this.closeEditor();
        }
    }

    public void setFocus() {
        if (this.fText != null) {
            this.fText.setFocus();
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        if (this.fText != null) {
            this.fText.setText(this.getText());
        }
        this.firePropertyChange(258);
    }

    protected String getText() {
        return String.valueOf(this.getEditorInput().getToolTipText()) + "\n";
    }

    protected void closeEditor() {
        CommonSourceNotFoundEditor editor = this;
        DebugUIPlugin.getStandardDisplay().syncExec(new Runnable((IEditorPart)editor){
            private final /* synthetic */ IEditorPart val$editor;
            {
                this.val$editor = iEditorPart;
            }

            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                    activePage.closeEditor(this.val$editor, false);
                }
            }
        });
    }

    public void dispose() {
        if (this.fLaunchesListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchesListener);
        }
        super.dispose();
    }

    protected Object getArtifact() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof CommonSourceNotFoundEditorInput) {
            CommonSourceNotFoundEditorInput input = (CommonSourceNotFoundEditorInput)editorInput;
            return input.getArtifact();
        }
        return null;
    }

    protected void initialize() {
        this.fLaunchesListener = new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                Object artifact = CommonSourceNotFoundEditor.this.getArtifact();
                if (artifact instanceof IDebugElement) {
                    IDebugElement element = (IDebugElement)artifact;
                    int i = 0;
                    while (i < launches.length) {
                        ILaunch launch = launches[i];
                        if (launch.equals(element.getLaunch())) {
                            CommonSourceNotFoundEditor.this.closeEditor();
                            return;
                        }
                        ++i;
                    }
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                this.launchesTerminated(launches);
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchesListener);
    }
}

