/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import org.eclipse.rcptt.expandbar.runtime.internal.ExpandBarUtil;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public class ExpandItemDescriber
implements IWidgetDescriber {
    private ExpandItem item;

    public ExpandItemDescriber(ExpandItem item) {
        this.item = item;
    }

    public Display getDisplay() {
        return this.item.getDisplay();
    }

    public Widget getWidget() {
        return this.item;
    }

    public void redraw() {
        this.item.getParent().redraw();
    }

    public Rectangle getBounds() {
        return ExpandBarUtil.getItemHeaderBounds(this.item);
    }

    public Point getPoint() {
        Rectangle bounds = this.getBounds();
        return this.getDisplay().map((Control)this.item.getParent(), null, bounds.x, bounds.y);
    }

    public Point getRealPoint() {
        return this.getPoint();
    }

    public IWidgetDescriber getControl() {
        return this;
    }

    public Widget getItemWidget() {
        return this.item;
    }

    public Image captureImage() {
        return SWTUIPlayer.captureControlImageRaw((Control)this.item.getParent(), (Rectangle)this.getBounds());
    }

    public boolean supportsDND() {
        return false;
    }
}

