/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.CompositeChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.IErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryErrorPage;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;

public final class RefactoringHistoryPreviewPage
extends PreviewWizardPage {
    private RefactoringPreviewChangeFilter fFilter = new RefactoringPreviewChangeFilter();
    private boolean fNextPageDisabled = false;
    private Refactoring fRefactoring;
    private RefactoringStatus fStatus = new RefactoringStatus();

    public RefactoringHistoryPreviewPage() {
        super(true);
        this.setTitle(RefactoringUIMessages.RefactoringHistoryOverviewPage_title);
        this.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_description);
    }

    public boolean canFlipToNextPage() {
        return !this.fNextPageDisabled;
    }

    public IWizardPage getNextPage() {
        RefactoringStatusEntry entry;
        RefactoringStatus status;
        RefactoringHistoryWizard result;
        if (this.fChange != null && this.fRefactoring != null && !this.fStatus.hasFatalError() && (result = this.getRefactoringHistoryWizard()) != null && !(status = result.performPreviewChange(this.fChange, this.fRefactoring)).isOK() && (entry = status.getEntryWithHighestSeverity()) != null) {
            if (entry.getSeverity() == 1 && entry.getCode() == 10003) {
                return this;
            }
            IErrorWizardPage page = result.getErrorPage();
            if (page instanceof RefactoringHistoryErrorPage) {
                RefactoringHistoryErrorPage extended = (RefactoringHistoryErrorPage)page;
                extended.setStatus(status);
                extended.setNextPageDisabled(this.fNextPageDisabled);
                extended.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                extended.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                return extended;
            }
        }
        return this.getWizard().getNextPage((IWizardPage)this);
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPreviousPage((IWizardPage)this);
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    protected RefactoringHistoryWizard getRefactoringHistoryWizard() {
        IWizard result = this.getWizard();
        if (result instanceof RefactoringHistoryWizard) {
            return (RefactoringHistoryWizard)result;
        }
        return null;
    }

    public boolean isNextPageDisabled() {
        return this.fNextPageDisabled;
    }

    protected boolean performFinish() {
        return true;
    }

    public void setFilter(RefactoringPreviewChangeFilter filter) {
        Assert.isNotNull((Object)filter);
        this.fFilter = filter;
    }

    public void setNextPageDisabled(boolean disable) {
        this.fNextPageDisabled = disable;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(!this.fNextPageDisabled);
    }

    public void setRefactoring(Refactoring refactoring) {
        this.fRefactoring = refactoring;
    }

    public void setStatus(RefactoringStatus status) {
        Assert.isNotNull((Object)status);
        this.fStatus = status;
    }

    public void setTitle(RefactoringDescriptorProxy descriptor, int current, int total) {
        String message = descriptor != null ? descriptor.getDescription() : RefactoringUIMessages.RefactoringHistoryOverviewPage_title;
        if (total > 1) {
            this.setTitle(Messages.format(RefactoringUIMessages.RefactoringHistoryPreviewPage_refactoring_pattern, new String[]{message, String.valueOf(current + 1), String.valueOf(total)}));
        } else {
            this.setTitle(message);
        }
    }

    protected void setTreeViewerInput() {
        CompositeChangeNode node;
        PreviewNode[] nodes;
        if (this.fTreeViewer == null) {
            return;
        }
        PreviewNode input = null;
        if (this.fTreeViewerInputChange != null) {
            input = AbstractChangeNode.createNode(null, this.fFilter, (Change)this.fTreeViewerInputChange);
        }
        if (input instanceof CompositeChangeNode && ((nodes = (node = (CompositeChangeNode)input).getChildren()) == null || nodes.length == 0)) {
            this.fTreeViewerPane.setText(RefactoringUIMessages.RefactoringHistoryPreviewPage_no_changes);
            this.fNextAction.setEnabled(false);
            this.fPreviousAction.setEnabled(false);
            this.fFilterDropDownAction.setEnabled(false);
            this.fTreeViewer.setInput(null);
            return;
        }
        this.fTreeViewerPane.setText(RefactoringUIMessages.PreviewWizardPage_changes);
        this.fNextAction.setEnabled(true);
        this.fPreviousAction.setEnabled(true);
        this.fFilterDropDownAction.setEnabled(true);
        this.fTreeViewer.setInput(input);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fTreeViewer.getInput() == null) {
            this.fFilterDropDownAction.setEnabled(false);
        }
    }

    public void setWizard(IWizard newWizard) {
        Assert.isTrue((boolean)(newWizard instanceof RefactoringHistoryWizard));
        super.setWizard(newWizard);
    }
}

