/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;

public class IdeNonSourceOutputStream
extends ByteArrayOutputStream {
    private final IdeProcessingEnvImpl _env;
    private final IFile _file;
    private final Collection<IFile> _parentFiles;

    public IdeNonSourceOutputStream(IdeProcessingEnvImpl env, IFile file, Collection<IFile> parentFiles) {
        this._env = env;
        this._file = file;
        this._parentFiles = parentFiles;
    }

    @Override
    public void close() throws IOException {
        block11: {
            super.close();
            ByteArrayInputStream contents = new ByteArrayInputStream(this.toByteArray());
            try {
                boolean contentsChanged;
                block13: {
                    contentsChanged = true;
                    if (!this._file.exists()) {
                        this.saveToDisk(contents, true);
                        break block11;
                    }
                    ByteArrayInputStream in = null;
                    BufferedInputStream oldData = null;
                    try {
                        try {
                            in = new ByteArrayInputStream(this.toByteArray());
                            oldData = new BufferedInputStream(this._file.getContents());
                            if (FileSystemUtil.compareStreams((InputStream)in, (InputStream)oldData)) {
                                contentsChanged = false;
                            }
                        }
                        catch (CoreException coreException) {
                            contentsChanged = true;
                            this.closeInputStream(in);
                            this.closeInputStream(oldData);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeInputStream(in);
                        this.closeInputStream(oldData);
                        throw throwable;
                    }
                    this.closeInputStream(in);
                    this.closeInputStream(oldData);
                }
                if (contentsChanged) {
                    ((InputStream)contents).reset();
                    this.saveToDisk(contents, false);
                }
            }
            finally {
                this.closeInputStream(contents);
            }
        }
        if (this._parentFiles != null && !this._parentFiles.isEmpty()) {
            this._env.getAptProject().getGeneratedFileManager().addGeneratedFileDependency(this._parentFiles, this._file);
            this._env.addNewResource(this._file);
        }
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void saveToDisk(InputStream toSave, boolean create) throws IOException {
        block4: {
            try {
                FileSystemUtil.makeDerivedParentFolders((IContainer)this._file.getParent());
                if (create) {
                    this._file.create(toSave, 1025, null);
                } else {
                    this._file.setContents(toSave, true, false, null);
                }
            }
            catch (CoreException ce) {
                if (this._file.exists()) break block4;
                Apt6Plugin.log(ce, "Could not create generated non-Java file " + this._file.getName());
                IOException ioe = new IOException();
                ioe.initCause(ce);
                throw ioe;
            }
        }
    }
}

