/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.internal.launching.ext.ui.wizards.NewAUTPage;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.ui.launching.aut.IAUTConfigWizard;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class EditAUTWizard
extends Wizard
implements IAUTConfigWizard {
    private static final String ATTR_D32 = "-d32";
    private NewAUTPage page;
    private ILaunchConfiguration configuration;
    private WizardDialog wizardDialog;

    public EditAUTWizard() {
        this.setWindowTitle("Edit Application Under Test");
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new NewAUTPage("edit", "Edit Application Under Test", null);
        try {
            String configName = this.configuration.getName();
            String autLocation = this.configuration.getAttribute("aut-location", "");
            String targetName = this.configuration.getAttribute("aut-target-platform", "");
            this.page.initializeExisting(configName, autLocation, targetName, this.configuration);
            this.page.addAdvancedHandler(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    EditAUTWizard.this.wizardDialog.close();
                    DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)EditAUTWizard.this.configuration, (String)"org.eclipse.debug.ui.launchGroup.run");
                }
            });
        }
        catch (Throwable e) {
            Q7UIPlugin.log((Throwable)e);
        }
        this.addPage((IWizardPage)this.page);
    }

    public boolean performCancel() {
        ITargetPlatformHelper target = this.page.getTarget();
        if (target != null && !target.isValid()) {
            target.delete();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        ITargetPlatformHelper target = this.page.getTarget();
        if (target.isValid()) {
            try {
                String programArgs;
                IVMInstall install;
                String targetName = Q7TargetPlatformManager.getTargetPlatformName((String)this.page.getTargetName());
                TargetPlatformManager.deleteTargetPlatform((String)targetName);
                target.setTargetName(targetName);
                target.save();
                File area = LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)this.configuration);
                if (area != null && area.exists()) {
                    FileUtil.deleteFile((File)area, (boolean)false);
                }
                LaunchInfoCache.remove((ILaunchConfiguration)this.configuration);
                ILaunchConfigurationWorkingCopy workingCopy = this.configuration.getWorkingCopy();
                Q7LaunchingUtil.updateLaunchConfiguration((ITargetPlatformHelper)target, (ILaunchConfigurationWorkingCopy)workingCopy);
                workingCopy.rename(this.page.getTargetName());
                OSArchitecture autArch = this.page.getArchitecture();
                workingCopy.setAttribute("com.xored.launching.common.attrArch", autArch.name());
                OSArchitecture jvmArch = this.page.getJVMArch();
                String vmArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, target.getIniVMArgs());
                vmArgs = vmArgs == null ? LaunchArgumentsHelper.getInitialVMArguments().trim() : vmArgs.trim();
                if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
                    vmArgs = vmArgs != null && !vmArgs.contains(ATTR_D32) ? String.valueOf(vmArgs) + " -d32" : ATTR_D32;
                }
                if (vmArgs != null && vmArgs.length() > 0) {
                    vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
                }
                if ((install = this.page.getJVMInstall()) != null) {
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", install.getVMInstallType().getId(), install.getName()));
                }
                if ((programArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, LaunchArgumentsHelper.getInitialProgramArguments().trim())).contains("${target.arch}")) {
                    programArgs = programArgs.replace("${target.arch}", autArch.name());
                } else if (programArgs.contains("-arch")) {
                    int pos = programArgs.indexOf("-arch ") + 6;
                    int len = 6;
                    int pos2 = programArgs.indexOf("x86_64", pos);
                    if (pos2 == -1) {
                        len = 3;
                        pos2 = programArgs.indexOf("x86", pos);
                    }
                    if (pos2 != -1) {
                        programArgs = String.valueOf(programArgs.substring(0, pos)) + autArch.name() + programArgs.substring(pos2 + len, programArgs.length());
                    }
                } else {
                    programArgs = String.valueOf(programArgs) + " -arch " + autArch.name();
                }
                if (programArgs.length() > 0) {
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
                }
                workingCopy.setAttribute("append.args", true);
                String product = target.getDefaultProduct();
                if (product != null) {
                    workingCopy.setAttribute("useProduct", true);
                    workingCopy.setAttribute("product", product);
                }
                workingCopy.setAttribute("clearws", false);
                workingCopy.setAttribute("askclear", true);
                workingCopy.setAttribute("clearwslog", false);
                workingCopy.setAttribute("location", EditAUTWizard.getDefaultWorkspaceLocation(workingCopy.getName()));
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.page.getTargetLocation());
                workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
                workingCopy.setAttribute("org.eclipse.debug.core.capture_output", false);
                List list = AutManager.INSTANCE.storeAUTLaunches(this.configuration);
                LaunchInfoCache.remove((ILaunchConfiguration)workingCopy);
                ILaunchConfiguration newConfig = workingCopy.doSave();
                LaunchInfoCache.remove((ILaunchConfiguration)newConfig);
                if (list != null) {
                    AutManager.INSTANCE.updateAUTLaunches(newConfig, list);
                }
                return true;
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        target.delete();
        return false;
    }

    public static String getDefaultWorkspaceLocation(String uniqueName) {
        return "${workspace_loc}/../aut-" + uniqueName.replaceAll("\\s", "");
    }

    public void setWizardDialog(WizardDialog dialog) {
        this.wizardDialog = dialog;
    }
}

