/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableTreeItemPathUtil {
    private static final Pattern columnItemPattern = Pattern.compile("(.*?)\\#(.*)\\#");

    public static String appendSegmentColumnName(String segment, String columnName) {
        if (TableTreeItemPathUtil.findColumnName(segment) == null && columnName != null) {
            return String.valueOf(segment) + "#" + columnName + "#";
        }
        return segment;
    }

    public static String getAppendingColumnName(String columnName) {
        if (columnName != null) {
            return "#" + columnName + "#";
        }
        return "";
    }

    public static List<String> appendSegmentsColumnName(List<String> path, String columnName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String segment : path) {
            result.add(TableTreeItemPathUtil.appendSegmentColumnName(segment, columnName));
        }
        return result;
    }

    public static String appendFullPathColumnName(List<String> path, String columnName) {
        StringBuilder res = new StringBuilder();
        for (String segment : path) {
            res.append(TableTreeItemPathUtil.appendSegmentColumnName(segment, columnName)).append('/');
        }
        res.deleteCharAt(res.length() - 1);
        return res.toString();
    }

    public static String appendFullPathColumnName(String path, String columnName) {
        if (columnName == null) {
            return path;
        }
        List<String> segments = TableTreeItemPathUtil.splitPath(path);
        return TableTreeItemPathUtil.appendFullPathColumnName(segments, columnName);
    }

    public static List<String> splitPath(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char next;
            char ch = path.charAt(i);
            if (ch == '/') {
                segments.add(segment.toString());
                segment = new StringBuilder();
            } else if (ch == '\\' && i + 1 < path.length() && (next = path.charAt(i + 1)) == '/') {
                ++i;
                segment.append('\\');
                segment.append(next);
            } else {
                segment.append(ch);
            }
            ++i;
        }
        segments.add(segment.toString());
        return segments;
    }

    public static String findColumnName(String segment) {
        if (segment == null) {
            return null;
        }
        Matcher m = columnItemPattern.matcher(segment);
        if (!m.matches()) {
            return null;
        }
        return m.group(2);
    }

    public static String excludeColumnName(String segment) {
        if (segment == null) {
            return null;
        }
        Matcher m = columnItemPattern.matcher(segment);
        if (!m.matches()) {
            return segment;
        }
        return m.group(1);
    }
}

