/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.reporting;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingData;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportBuilderStore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.EventProviderManager;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;

public class ReportBuilder
implements IReportBuilder {
    private final Report report;
    private NodeBuilder currentNode;

    private static Report createReport() {
        Report report = ReportFactory.eINSTANCE.createReport();
        Node root = ReportFactory.eINSTANCE.createNode();
        report.setRoot(root);
        root.setName("root");
        root.setStartTime(ReportBuilder.getTime());
        return report;
    }

    private ReportBuilder(Report report, Node currentNode) {
        this.report = report;
        this.currentNode = new NodeBuilder(null, currentNode);
        if (report.getRoot() == null) {
            throw new NullPointerException();
        }
        if (currentNode == null) {
            throw new NullPointerException();
        }
        Node root = currentNode;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root != report.getRoot()) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSource registerEventSource(String name) {
        EventSource source = ReportFactory.eINSTANCE.createEventSource();
        source.setName(name);
        Report report = this.report;
        synchronized (report) {
            this.report.getSources().add((Object)source);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReportCopy() {
        Report report = this.report;
        synchronized (report) {
            Report reportCopy = (Report)EcoreUtil.copy((EObject)this.report);
            reportCopy.getRoot().setEndTime(ReportBuilder.getTime());
            return reportCopy;
        }
    }

    @Override
    public INodeBuilder getCurrent() {
        return this.currentNode;
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void takeSnapshot(String type, String ... id) {
        if (id.length == 0) {
            EventProviderManager.getInstance().takeSnapshot(this, null, type);
        } else {
            String[] stringArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                String lid = stringArray[n2];
                EventProviderManager.getInstance().takeSnapshot(this, lid, type);
                ++n2;
            }
        }
    }

    public void registerProviders(String ... id) {
        if (id.length == 0) {
            EventProviderManager.getInstance().register(this, null);
        } else {
            String[] stringArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                String lid = stringArray[n2];
                EventProviderManager.getInstance().register(this, lid);
                ++n2;
            }
        }
    }

    public void unregisterProviders(String ... id) {
        if (id.length == 0) {
            EventProviderManager.getInstance().unregister(this, null);
        } else {
            String[] stringArray = id;
            int n = id.length;
            int n2 = 0;
            while (n2 < n) {
                String lid = stringArray[n2];
                EventProviderManager.getInstance().unregister(this, lid);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSource findSource(String attr, EObject info) {
        Report report = this.report;
        synchronized (report) {
            EList<EventSource> sources = this.report.getSources();
            for (EventSource eventSource : sources) {
                EObject object = (EObject)eventSource.getProperties().get((Object)attr);
                if (object == null || !EcoreUtil.equals((EObject)object, (EObject)info)) continue;
                return eventSource;
            }
        }
        return null;
    }

    private static String getLogCategoryKey(LoggingCategory category) {
        return "log_" + category.name();
    }

    public static String getLogs(Node node) {
        StringBuilder result = new StringBuilder();
        String logs = null;
        for (LoggingCategory cat : LoggingCategory.VALUES) {
            logs = ReportBuilder.getLogs(node, cat);
            if (logs == null) continue;
            result.append(logs);
        }
        return result.toString();
    }

    public static String getLogs(Node node, LoggingCategory cat) {
        EObject object = (EObject)node.getProperties().get((Object)ReportBuilder.getLogCategoryKey(cat));
        if (object != null && object instanceof LoggingData) {
            return ((LoggingData)object).getText();
        }
        return null;
    }

    public static ReportBuilder create(String title) {
        Report report = ReportBuilder.createReport();
        report.getRoot().setName(title);
        return new ReportBuilder(report, report.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportBuilderStore save() {
        ReportBuilderStore store = ReportFactory.eINSTANCE.createReportBuilderStore();
        Report report = this.report;
        synchronized (report) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            store.setReport((Report)copier.copy((EObject)this.report));
            store.setCurrentNode((Node)copier.get((Object)this.currentNode.node));
        }
        assert (store.getCurrentNode() != null);
        assert (store.getCurrentNode().eContainer() != null);
        store.getReport().getRoot().setEndTime(ReportBuilder.getTime());
        return store;
    }

    public static ReportBuilder load(ReportBuilderStore store) {
        return new ReportBuilder(store.getReport(), store.getCurrentNode());
    }

    public static Snaphot createSnapshot(EObject data, Map<String, EObject> properties) {
        Snaphot snapshot = ReportFactory.eINSTANCE.createSnaphot();
        snapshot.setTime(ReportBuilder.getTime());
        snapshot.setData(data);
        if (properties != null) {
            snapshot.getProperties().addAll(properties.entrySet());
        }
        return snapshot;
    }

    private class NodeBuilder
    implements INodeBuilder {
        private final Node node;
        private NodeBuilder parent;

        private NodeBuilder(NodeBuilder parent, Node node) {
            this.parent = parent;
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public INodeBuilder beginTask(String name) {
            Node child = ReportFactory.eINSTANCE.createNode();
            child.setName(name);
            child.setStartTime(ReportBuilder.getTime());
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.getChildren().add((Object)child);
                ReportBuilder.this.currentNode = new NodeBuilder(this, child);
            }
            return ReportBuilder.this.currentNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endTask() {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.setEndTime(ReportBuilder.getTime());
                if (this.parent != null) {
                    ReportBuilder.this.currentNode = this.parent;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createEvent(Event event) {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                Event copy = (Event)EcoreUtil.copy((EObject)event);
                copy.setTime(ReportBuilder.getTime());
                this.node.getEvents().add((Object)copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendLog(LoggingCategory category, String text) {
            String log_key = ReportBuilder.getLogCategoryKey(category);
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                EMap<String, EObject> properties = this.node.getProperties();
                LoggingData data = (LoggingData)properties.get((Object)log_key);
                if (data == null) {
                    data = ReportFactory.eINSTANCE.createLoggingData();
                    properties.put((Object)log_key, (Object)data);
                }
                StringBuilder sb = new StringBuilder(data.getText());
                sb.append(text);
                sb.append("\n");
                data.setText(sb.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProperty(String key, EObject value) {
            EObject copy = EcoreUtil.copy((EObject)value);
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                if (this.node.getProperties().containsKey((Object)key)) {
                    throw new IllegalStateException("Property " + key + " is already set for node" + this.node.getName());
                }
                this.node.getProperties().put((Object)key, (Object)copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSnapshot(Snaphot snapshot) {
            Snaphot copy = (Snaphot)EcoreUtil.copy((EObject)snapshot);
            copy.setTime(ReportBuilder.getTime());
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                this.node.getSnapshots().add((Object)copy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Procedure1<Node> runnable) {
            Report report = ReportBuilder.this.report;
            synchronized (report) {
                runnable.apply(this.node);
            }
        }
    }
}

