/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.sections.DSReferenceSection;
import org.eclipse.pde.internal.ds.ui.parts.ComboPart;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DSEditReferenceDialog
extends FormDialog {
    private IDSReference fReference;
    private FormEntry fNameEntry;
    private FormEntry fInterfaceEntry;
    private FormEntry fBindEntry;
    private FormEntry fUnBindEntry;
    private FormEntry fTargetEntry;
    private ComboPart fCardinality;
    private Label fLabelCardinality;
    private ComboPart fPolicy;
    private Label fLabelPolicy;
    private DSReferenceSection fReferenceSection;

    public DSEditReferenceDialog(Shell parentShell, IDSReference reference, DSReferenceSection referenceSection) {
        super(parentShell);
        this.fReference = reference;
        this.fReferenceSection = referenceSection;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.DSEditReferenceDialog_dialog_title);
        Composite container = mform.getForm().getBody();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        FormToolkit toolkit = mform.getToolkit();
        toolkit.decorateFormHeading(mform.getForm().getForm());
        Composite entryContainer = toolkit.createComposite(container);
        entryContainer.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        entryContainer.setLayoutData((Object)new GridData(1808));
        this.fNameEntry = new FormEntry(entryContainer, toolkit, Messages.DSReferenceDetails_nameEntry, 0);
        this.fInterfaceEntry = new FormEntry(entryContainer, toolkit, Messages.DSReferenceDetails_interfaceEntry, Messages.DSReferenceDetails_browse, false, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 3;
        this.addCardinalityEntry(toolkit, entryContainer, gd);
        this.addPolicyEntry(toolkit, entryContainer, gd);
        this.fTargetEntry = new FormEntry(entryContainer, toolkit, Messages.DSReferenceDetails_targetEntry, 0);
        this.fBindEntry = new FormEntry(entryContainer, toolkit, Messages.DSReferenceDetails_bindEntry, 0);
        this.fUnBindEntry = new FormEntry(entryContainer, toolkit, Messages.DSReferenceDetails_unbindEntry, 0);
        toolkit.paintBordersFor(entryContainer);
        this.updateFields();
        this.setInterfaceEntryListeners();
        toolkit.paintBordersFor(entryContainer);
    }

    private void addCardinalityEntry(FormToolkit toolkit, Composite container3, GridData gd) {
        this.fLabelCardinality = toolkit.createLabel(container3, Messages.DSReferenceDetails_cardinalityLabel, 64);
        this.fLabelCardinality.setForeground(toolkit.getColors().getForeground());
        this.fCardinality = new ComboPart();
        this.fCardinality.createControl(container3, toolkit, 8);
        String[] itemsCard = new String[]{"0..1", "0..n", "1..1", "1..n"};
        this.fCardinality.setItems(itemsCard);
        this.fCardinality.getControl().setLayoutData((Object)gd);
    }

    private void addPolicyEntry(FormToolkit toolkit, Composite container3, GridData gd) {
        this.fLabelPolicy = toolkit.createLabel(container3, Messages.DSReferenceDetails_policeLabel, 64);
        this.fLabelPolicy.setForeground(toolkit.getColors().getForeground());
        this.fPolicy = new ComboPart();
        this.fPolicy.createControl(container3, toolkit, 8);
        String[] itemsPolicy = new String[]{"static", "dynamic"};
        this.fPolicy.setItems(itemsPolicy);
        this.fPolicy.getControl().setLayoutData((Object)gd);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.handleOKPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void handleOKPressed() {
        this.fNameEntry.commit();
        if (!(this.fNameEntry.getValue().equals("") && this.fReference.getReferenceName() == null || this.fNameEntry.getValue().equals(this.fReference.getReferenceName()))) {
            this.fReference.setReferenceName(this.fNameEntry.getValue());
        }
        this.fInterfaceEntry.commit();
        if (!(this.fInterfaceEntry.getValue().equals("") && this.fReference.getReferenceInterface() == null || this.fInterfaceEntry.getValue().equals(this.fReference.getReferenceInterface()))) {
            this.fReference.setReferenceInterface(this.fInterfaceEntry.getValue());
        }
        this.fBindEntry.commit();
        if (!(this.fBindEntry.getValue().equals("") && this.fReference.getReferenceBind() == null || this.fBindEntry.getValue().equals(this.fReference.getReferenceBind()))) {
            this.fReference.setReferenceBind(this.fBindEntry.getValue());
        }
        this.fUnBindEntry.commit();
        if (!(this.fUnBindEntry.getValue().equals("") && this.fReference.getReferenceUnbind() == null || this.fUnBindEntry.getValue().equals(this.fReference.getReferenceUnbind()))) {
            this.fReference.setReferenceUnbind(this.fUnBindEntry.getValue());
        }
        this.fTargetEntry.commit();
        if (!(this.fTargetEntry.getValue().equals("") && this.fReference.getReferenceTarget() == null || this.fTargetEntry.getValue().equals(this.fReference.getReferenceTarget()))) {
            this.fReference.setReferenceTarget(this.fTargetEntry.getValue());
        }
        if (this.fCardinality.getSelection() != null && !this.fCardinality.getSelection().equals(this.fReference.getReferenceCardinality())) {
            this.fReference.setReferenceCardinality(this.fCardinality.getSelection());
        }
        if (this.fPolicy.getSelection() != null && !this.fPolicy.getSelection().equals(this.fReference.getReferencePolicy())) {
            this.fReference.setReferencePolicy(this.fPolicy.getSelection());
        }
    }

    private void updateFields() {
        if (this.fReference == null) {
            return;
        }
        if (this.fReference.getReferenceName() == null) {
            this.fNameEntry.setValue("");
        } else {
            this.fNameEntry.setValue(this.fReference.getReferenceName(), true);
        }
        this.fNameEntry.setEditable(true);
        if (this.fReference.getReferenceInterface() == null) {
            this.fInterfaceEntry.setValue("");
        } else {
            this.fInterfaceEntry.setValue(this.fReference.getReferenceInterface(), true);
        }
        this.fInterfaceEntry.setEditable(true);
        this.fTargetEntry.setValue(this.fReference.getReferenceTarget(), true);
        this.fTargetEntry.setEditable(true);
        this.fBindEntry.setValue(this.fReference.getReferenceBind(), true);
        this.fBindEntry.setEditable(true);
        this.fUnBindEntry.setValue(this.fReference.getReferenceUnbind(), true);
        this.fUnBindEntry.setEditable(true);
        if (this.fReference.getReferenceCardinality() != null) {
            this.fCardinality.setText(this.fReference.getReferenceCardinality());
        }
        if (this.fReference.getReferencePolicy() != null) {
            this.fPolicy.setText(this.fReference.getReferencePolicy());
        }
    }

    public void setInterfaceEntryListeners() {
        this.fInterfaceEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this.fReferenceSection){

            public void textValueChanged(FormEntry entry) {
            }

            public void textDirty(FormEntry entry) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = DSEditReferenceDialog.this.fInterfaceEntry.getValue();
                if ((value = DSEditReferenceDialog.this.handleLinkActivated(value, false)) != null) {
                    DSEditReferenceDialog.this.fInterfaceEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                DSEditReferenceDialog.this.doOpenSelectionDialog(512, DSEditReferenceDialog.this.fInterfaceEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private IProject getProject() {
        PDEFormEditor editor = (PDEFormEditor)this.fReferenceSection.getPage().getEditor();
        return editor.getCommonProject();
    }

    private void doOpenSelectionDialog(int scopeType, FormEntry entry) {
        try {
            String filter = entry.getValue();
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Activator.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(Messages.DSReferenceDetails_selectType);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                entry.setValue(type.getFullyQualifiedName('$'));
                entry.commit();
            }
        }
        catch (CoreException coreException) {}
    }
}

