/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.progress.IProgressService;

public class OpenRevisionAction
extends BaseSelectionListenerAction {
    private IStructuredSelection selection;
    private HistoryPage page;

    public OpenRevisionAction(String text, HistoryPage page) {
        super(text);
        this.page = page;
    }

    public void run() {
        IStructuredSelection structSel = this.selection;
        if (structSel == null) {
            return;
        }
        Object[] objArray = structSel.toArray();
        int i = 0;
        while (i < objArray.length) {
            Object tempRevision = objArray[i];
            if (!(tempRevision instanceof AbstractHistoryCategory)) {
                final IFileRevision revision = (IFileRevision)tempRevision;
                if (revision == null || !revision.exists()) {
                    MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevTitle, (String)TeamUIMessages.OpenRevisionAction_DeletedRevMessage);
                } else {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Utils.openEditor(OpenRevisionAction.this.page.getSite().getPage(), revision, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        progressService.run(false, false, runnable);
                    }
                    catch (InvocationTargetException e) {
                        Utils.handleError(this.page.getSite().getShell(), e, TeamUIMessages.OpenRevisionAction_ErrorTitle, TeamUIMessages.OpenRevisionAction_ErrorMessage);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return this.shouldShow();
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            if (objArray[i] instanceof AbstractHistoryCategory) {
                return false;
            }
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

