/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandWithConstructorsConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String WILDCARD = ".*";
    private static final int IDX_NEW_TYPE = 0;
    private static final int IDX_NEW_MEMBER = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_RESTORE_DEFAULTS = 4;
    private ListDialogField<String> fList;
    private Button fAnonymousButton;
    protected boolean fIsAnonymous;
    private static OptionsConfigurationBlock.Key DEFAULT_EXPAND_WITH_CONSTRUCTORS_MEMBERS = ExpandWithConstructorsConfigurationBlock.getJDTUIKey("CallHierarchy.defaultExpandWithConstructorsMembers");
    private static OptionsConfigurationBlock.Key ANONYMOUS_EXPAND_WITH_CONSTRUCTORS = ExpandWithConstructorsConfigurationBlock.getJDTUIKey("CallHierarchy.anonymousExpandWithConstructors");

    @Override
    public boolean performOk() {
        this.setValue(ANONYMOUS_EXPAND_WITH_CONSTRUCTORS, this.fIsAnonymous);
        return super.performOk();
    }

    public static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{DEFAULT_EXPAND_WITH_CONSTRUCTORS_MEMBERS, ANONYMOUS_EXPAND_WITH_CONSTRUCTORS};
    }

    public ExpandWithConstructorsConfigurationBlock(IStatusChangeListener context, IWorkbenchPreferenceContainer container) {
        super(context, null, ExpandWithConstructorsConfigurationBlock.getAllKeys(), container);
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        control.setLayout((Layout)layout);
        this.createPreferenceList(control);
        this.fAnonymousButton = new Button(control, 32);
        this.fAnonymousButton.setText(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_anonymousTypes_label);
        this.fIsAnonymous = this.getBooleanValue(ANONYMOUS_EXPAND_WITH_CONSTRUCTORS);
        this.fAnonymousButton.setSelection(this.fIsAnonymous);
        this.fAnonymousButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fAnonymousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpandWithConstructorsConfigurationBlock.this.fIsAnonymous = ExpandWithConstructorsConfigurationBlock.this.fAnonymousButton.getSelection();
            }
        });
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private void createPreferenceList(Composite parent) {
        String[] buttonLabels = new String[]{CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_newType_button, CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_newMember_button, CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_edit_button, CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_remove_button, CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_restoreDefaults_button};
        ListAdapter adapter = new ListAdapter();
        this.fList = new ListDialogField<String>(adapter, buttonLabels, (ILabelProvider)new ListLabelProvider());
        this.fList.setDialogFieldListener(adapter);
        this.fList.setLabelText(CallHierarchyMessages.ExpandWithConstructorsConfigurationBlock_description);
        this.fList.setRemoveButtonIndex(3);
        this.fList.enableButton(2, false);
        this.fList.setViewerComparator(new ViewerComparator());
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        this.fList.doFillIntoGrid(parent, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fList.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fList.getListControl(null));
        Control listControl = this.fList.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(10);
    }

    public void initialize() {
        this.fList.setElements(Arrays.asList(this.getDefaultExpandWithConstructorsMembers()));
    }

    @Override
    public void performDefaults() {
        String str = PreferenceConstants.getPreferenceStore().getDefaultString("CallHierarchy.defaultExpandWithConstructorsMembers");
        this.fList.setElements(Arrays.asList(ExpandWithConstructorsConfigurationBlock.deserializeMembers(str)));
        this.fIsAnonymous = PreferenceConstants.getPreferenceStore().getDefaultBoolean("CallHierarchy.anonymousExpandWithConstructors");
        this.fAnonymousButton.setSelection(this.fIsAnonymous);
        super.performDefaults();
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    private void doButtonPressed(int index) {
        if (index == 0 || index == 1) {
            List<String> existing = this.fList.getElements();
            CallHierarchyTypesOrMembersDialog dialog = new CallHierarchyTypesOrMembersDialog(this.getShell(), existing, index == 1);
            if (dialog.open() == 0) {
                this.fList.addElement(dialog.getResult());
            }
        } else if (index == 2) {
            List<String> selected = this.fList.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            String editedEntry = selected.get(0);
            List<String> existing = this.fList.getElements();
            existing.remove(editedEntry);
            boolean isType = editedEntry.endsWith(WILDCARD);
            CallHierarchyTypesOrMembersDialog dialog = new CallHierarchyTypesOrMembersDialog(this.getShell(), existing, !isType);
            if (isType) {
                dialog.setInitialSelection(editedEntry.substring(0, editedEntry.length() - 2));
            } else {
                dialog.setInitialSelection(editedEntry);
            }
            if (dialog.open() == 0) {
                this.fList.replaceElement(editedEntry, dialog.getResult());
            }
        } else if (index == 4) {
            this.performDefaults();
        }
    }

    protected final void doDialogFieldChanged(DialogField field) {
        if (field == this.fList) {
            this.setValue(DEFAULT_EXPAND_WITH_CONSTRUCTORS_MEMBERS, ExpandWithConstructorsConfigurationBlock.serializeMembers(this.fList.getElements()));
        }
    }

    private String[] getDefaultExpandWithConstructorsMembers() {
        String str = this.getValue(DEFAULT_EXPAND_WITH_CONSTRUCTORS_MEMBERS);
        if (str != null && str.length() > 0) {
            return ExpandWithConstructorsConfigurationBlock.deserializeMembers(str);
        }
        return new String[0];
    }

    private static String[] deserializeMembers(String str) {
        return str.split(";");
    }

    public static String serializeMembers(List<String> list) {
        int size = list.size();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size) {
            buf.append(list.get(i));
            if (i < size - 1) {
                buf.append(';');
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallHierarchyTypesOrMembersDialog
    extends StatusDialog {
        private StringButtonDialogField fNameDialogField;
        private List<String> fExistingEntries;
        private final boolean fIsEditingMember;

        public CallHierarchyTypesOrMembersDialog(Shell parent, List<String> existingEntries, boolean isEditingMember) {
            super(parent);
            String label;
            String title;
            this.fIsEditingMember = isEditingMember;
            this.fExistingEntries = existingEntries;
            if (isEditingMember) {
                title = CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_member_title;
                label = CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_member_labelText;
            } else {
                title = CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_type_title;
                label = CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_type_labelText;
            }
            this.setTitle(title);
            StringButtonAdapter adapter = new StringButtonAdapter();
            this.fNameDialogField = new StringButtonDialogField(adapter);
            this.fNameDialogField.setLabelText(label);
            this.fNameDialogField.setButtonLabel(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_browse_button);
            this.fNameDialogField.setDialogFieldListener(adapter);
            this.fNameDialogField.setText("");
        }

        protected boolean isResizable() {
            return true;
        }

        public void setInitialSelection(String editedEntry) {
            Assert.isNotNull((Object)editedEntry);
            if (editedEntry.length() == 0) {
                this.fNameDialogField.setText("");
            } else {
                this.fNameDialogField.setText(editedEntry);
            }
        }

        public String getResult() {
            String val = this.fNameDialogField.getText();
            if (!this.fIsEditingMember) {
                val = String.valueOf(val) + ExpandWithConstructorsConfigurationBlock.WILDCARD;
            }
            return val;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)composite);
            GridLayout layout = (GridLayout)composite.getLayout();
            layout.numColumns = 2;
            this.fNameDialogField.doFillIntoGrid(composite, 3);
            this.fNameDialogField.getChangeControl(null).setVisible(!this.fIsEditingMember);
            LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
            int fieldWidthHint = this.convertWidthInCharsToPixels(60);
            Text text = this.fNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, fieldWidthHint);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            LayoutUtil.setHorizontalSpan((Control)text, this.fIsEditingMember ? 2 : 1);
            TextFieldNavigationHandler.install(text);
            DialogField.createEmptySpace(composite, 1);
            this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
            CallHierarchyTypesOrMembersDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doBrowseTypes() {
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            int style = 256;
            try {
                SelectionDialog dialog = JavaUI.createTypeDialog(this.getShell(), context, scope, style, false, this.fNameDialogField.getText());
                dialog.setTitle(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_ChooseTypeDialog_title);
                dialog.setMessage(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_ChooseTypeDialog_description);
                if (dialog.open() == 0) {
                    IType res = (IType)dialog.getResult()[0];
                    this.fNameDialogField.setText(res.getFullyQualifiedName('.'));
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_ChooseTypeDialog_title, CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_ChooseTypeDialog_error_message);
            }
        }

        private void doValidation() {
            StatusInfo status = new StatusInfo();
            String newText = this.fNameDialogField.getText();
            if (newText.length() == 0) {
                status.setError("");
            } else {
                IStatus val = JavaConventions.validateJavaTypeName((String)newText, (String)"1.3", (String)"1.3");
                if (val.matches(4)) {
                    if (this.fIsEditingMember) {
                        status.setError(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_error_invalidMemberName);
                    } else {
                        status.setError(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_error_invalidTypeName);
                    }
                } else if (this.doesExist(newText)) {
                    status.setError(CallHierarchyMessages.CallHierarchyTypesOrMembersDialog_error_entryExists);
                }
            }
            this.updateStatus(status);
        }

        private boolean doesExist(String name) {
            int i = 0;
            while (i < this.fExistingEntries.size()) {
                String entry = this.fExistingEntries.get(i);
                if (name.equals(entry)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.call_hierarchy_expand_with_constructors_dialog_context");
        }

        private class StringButtonAdapter
        implements IDialogFieldListener,
        IStringButtonAdapter {
            private StringButtonAdapter() {
            }

            public void dialogFieldChanged(DialogField field) {
                CallHierarchyTypesOrMembersDialog.this.doValidation();
            }

            public void changeControlPressed(DialogField field) {
                CallHierarchyTypesOrMembersDialog.this.doBrowseTypes();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListAdapter
    implements IListAdapter<String>,
    IDialogFieldListener {
        private ListAdapter() {
        }

        private boolean canEdit(ListDialogField<String> field) {
            List<String> selected = field.getSelectedElements();
            return selected.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField<String> field, int index) {
            ExpandWithConstructorsConfigurationBlock.this.doButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField<String> field) {
            ExpandWithConstructorsConfigurationBlock.this.fList.enableButton(2, this.canEdit(field));
            ExpandWithConstructorsConfigurationBlock.this.fList.enableButton(3, this.canRemove(field));
        }

        private boolean canRemove(ListDialogField<String> field) {
            List<String> selected = field.getSelectedElements();
            return selected.size() != 0;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ExpandWithConstructorsConfigurationBlock.this.doDialogFieldChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField<String> field) {
            if (this.canEdit(field)) {
                ExpandWithConstructorsConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ListLabelProvider
    extends LabelProvider {
        public final Image MEMBER_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 0, JavaElementImageProvider.SMALL_SIZE);
        private final Image CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object element) {
            return ((String)element).endsWith(ExpandWithConstructorsConfigurationBlock.WILDCARD) ? this.CLASS_ICON : this.MEMBER_ICON;
        }

        public String getText(Object element) {
            return BasicElementLabels.getJavaElementName((String)element);
        }
    }
}

