/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BulletListBlock
extends Composite {
    private StyledText fStyledText;
    private boolean fEnabled = true;
    private String fText = "";

    public BulletListBlock(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createControl(this);
    }

    private Control createControl(Composite parent) {
        this.fStyledText = new StyledText(parent, 0x800B00);
        this.fStyledText.setEditable(false);
        Cursor arrowCursor = this.fStyledText.getDisplay().getSystemCursor(0);
        this.fStyledText.setCursor(arrowCursor);
        GridData data = new GridData(1808);
        this.fStyledText.setLayoutData((Object)data);
        this.configureStyledText(this.fText, this.fEnabled);
        return this.fStyledText;
    }

    public void setText(String text) {
        this.fText = text;
        this.configureStyledText(this.fText, this.fEnabled);
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.configureStyledText(this.fText, this.fEnabled);
    }

    private void configureStyledText(String text, boolean enabled) {
        if (this.fStyledText == null) {
            return;
        }
        this.fStyledText.setText(text);
        int count = this.fStyledText.getCharCount();
        if (count == 0) {
            return;
        }
        Color foreground = enabled ? null : Display.getDefault().getSystemColor(16);
        this.fStyledText.setStyleRange(new StyleRange(0, count, foreground, null));
        StyleRange styleRange = new StyleRange(0, count, foreground, null);
        styleRange.metrics = new GlyphMetrics(0, 0, 20);
        this.fStyledText.setLineBullet(0, this.fStyledText.getLineCount(), new Bullet(styleRange));
        this.fStyledText.setEnabled(enabled);
    }
}

