/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpProfileVersioner
implements IProfileVersioner {
    public static final String PROFILE_KIND = "CleanUpProfile";
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    public static final int CURRENT_VERSION = 2;

    @Override
    public int getFirstVersion() {
        return 1;
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public void update(ProfileManager.CustomProfile profile) {
        Map<String, String> oldSettings = profile.getSettings();
        Map<String, String> newSettings = this.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(2);
        profile.setSettings(newSettings);
    }

    private Map<String, String> updateAndComplete(Map<String, String> oldSettings, int version) {
        Map<String, String> newSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
        switch (version) {
            case 1: {
                CleanUpProfileVersioner.updateFrom1To2(oldSettings);
            }
        }
        for (String key : oldSettings.keySet()) {
            String value;
            if (!newSettings.containsKey(key) || (value = oldSettings.get(key)) == null) continue;
            newSettings.put(key, value);
        }
        return newSettings;
    }

    @Override
    public String getProfileKind() {
        return PROFILE_KIND;
    }

    private static void updateFrom1To2(Map<String, String> settings) {
        MapCleanUpOptions defaultSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1);
        settings.put("cleanup.organize_imports", defaultSettings.getValue("cleanup.organize_imports"));
    }
}

