/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.runtime.ui.Utils;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQClient;
import org.eclipse.rcptt.tesla.internal.ui.player.ReportScreenshotProvider;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class UIRunnable<T> {
    public static <T> T exec(final UIRunnable<T> runnable) throws CoreException {
        Throwable[] exception;
        Object[] result;
        block14: {
            result = new Object[1];
            final RunningState[] processed = new RunningState[]{RunningState.Starting};
            exception = new Throwable[1];
            final UIJobCollector collector = new UIJobCollector();
            final Display display = PlatformUI.getWorkbench().getDisplay();
            Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
            collector.enable();
            ITeslaEventListener listener = null;
            try {
                try {
                    listener = new ITeslaEventListener(){

                        public synchronized boolean doProcessing(ContextManagement.Context currentContext) {
                            boolean tick = processed[0].equals((Object)RunningState.Starting) || processed[0].equals((Object)RunningState.Execution);
                            Q7WaitInfoRoot info = TeslaBridge.getCurrentWaitInfo((boolean)tick);
                            boolean resultValue = true;
                            if (!PlatformUI.getWorkbench().getDisplay().equals(Display.getCurrent())) {
                                resultValue = false;
                            }
                            if (SWTUIPlayer.hasTimers((Display)display, (Q7WaitInfoRoot)info)) {
                                resultValue = false;
                            }
                            if (SWTUIPlayer.hasRunnables((Display)display)) {
                                resultValue = false;
                            }
                            if (!collector.isEmpty(currentContext, info)) {
                                resultValue = false;
                            }
                            if (!resultValue) {
                                return false;
                            }
                            if (processed[0].equals((Object)RunningState.Starting)) {
                                processed[0] = RunningState.Execution;
                                try {
                                    result[0] = runnable.run();
                                }
                                catch (Throwable e) {
                                    exception[0] = e;
                                    collector.setNeedDisable();
                                    processed[0] = RunningState.Finished;
                                    return true;
                                }
                                processed[0] = RunningState.Done;
                                return true;
                            }
                            if (processed[0].equals((Object)RunningState.Done)) {
                                collector.setNeedDisable();
                                processed[0] = RunningState.Finished;
                                return true;
                            }
                            return false;
                        }

                        public void hasEvent(TeslaEventManager.HasEventKind kind, String run) {
                        }
                    };
                    TeslaEventManager.getManager().addEventListener(listener);
                    if (!display.isDisposed()) {
                        SWTUIPlayer.notifyUI((Display)display);
                    }
                    long start = System.currentTimeMillis();
                    while (!processed[0].equals((Object)RunningState.Finished) && !display.isDisposed()) {
                        SWTUIPlayer.notifyUI((Display)display);
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        long time = System.currentTimeMillis();
                        if (time > start + (long)(UIRunnable.getTimeout() / 2) && processed[0].equals((Object)RunningState.Starting)) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Utils.closeDialogs();
                                }
                            });
                            collector.clean();
                        }
                        if (time <= start + (long)UIRunnable.getTimeout()) continue;
                        UIRunnable.storeTimeoutInReport(display, collector);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runtime.ui", "Timeout during context execution..."));
                    }
                    long timeoutLeft = System.currentTimeMillis() - start;
                    long timeLeft = (long)UIRunnable.getTimeout() - timeoutLeft;
                    if (timeLeft < 0L) {
                        timeLeft = 5000L;
                    }
                    collector.join(timeLeft);
                }
                catch (Exception e) {
                    try {
                        RcpttPlugin.log((Throwable)e);
                    }
                    catch (Exception exception2) {}
                    exception[0] = e;
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
                    TeslaEventManager.getManager().removeEventListener(listener);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
                TeslaEventManager.getManager().removeEventListener(listener);
                throw throwable;
            }
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
            TeslaEventManager.getManager().removeEventListener(listener);
        }
        if (exception[0] != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.core", exception[0].getMessage(), exception[0]));
        }
        return (T)result[0];
    }

    private static int getTimeout() {
        return TeslaLimits.getContextRunnableTimeout();
    }

    private static void storeTimeoutInReport(final Display display, UIJobCollector collector) {
        final ReportBuilder currentBuilder = ReportManager.getBuilder();
        final boolean[] infoCollected = new boolean[1];
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ReportScreenshotProvider.takeScreenshot((Display)display, (boolean)true, (String)"timeout");
                TeslaQClient client = TeslaBridge.getClient();
                if (client != null) {
                    client.collectLastFailureInformation();
                    currentBuilder.takeSnapshot(null, ReportManager.eventProviders);
                }
                infoCollected[0] = true;
            }
        });
        long waitStart = System.currentTimeMillis();
        while (!infoCollected[0] && System.currentTimeMillis() - waitStart < 5000L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!infoCollected[0]) {
            AdvancedInformation info = TeslaBridge.getLastInfo();
            if (info == null) {
                info = InfoFactory.eINSTANCE.createAdvancedInformation();
                GeneralInformationCollector.collectInformation((AdvancedInformation)info);
            }
            if (info != null && currentBuilder != null) {
                ReportHelper.addSnapshotWithData((INodeBuilder)currentBuilder.getCurrent(), (EObject)info);
            }
        }
    }

    public static <T> T safeExec(UIRunnable<T> runnable) {
        try {
            return UIRunnable.exec(runnable);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public abstract T run() throws CoreException;

    private static enum RunningState {
        Starting,
        Execution,
        Done,
        Finished;

    }
}

